/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class WyPatreon {
    public static final HashMap<UUID, List<APIConfig.AccountType>> PATREONS = new HashMap();

    public static boolean isDevBuild() {
        return APIConfig.BUILD_MODE == APIConfig.BuildMode.DEV;
    }

    public static boolean isEarlyAccessBuild() {
        return APIConfig.BUILD_MODE == APIConfig.BuildMode.EARLY_ACCESS;
    }

    public static boolean isReleaseBuild() {
        return APIConfig.BUILD_MODE == APIConfig.BuildMode.RELEASE;
    }

    public static boolean isQABuild() {
        return APIConfig.BUILD_MODE == APIConfig.BuildMode.QA;
    }

    public static boolean isPromoBuild() {
        return APIConfig.BUILD_MODE == APIConfig.BuildMode.PROMO;
    }

    @Nullable
    private static List<APIConfig.AccountType> getPatreonLevel(PlayerEntity player) throws IOException {
        String apiURL = "/patreon/c142a238-b214-46b0-8820-139df67be10b";
        String[] result = (String[])WyHelper.sendGET(apiURL, String[].class);
        if (result != null && result.length > 0) {
            ArrayList<APIConfig.AccountType> types = new ArrayList<APIConfig.AccountType>();
            for (String group : result) {
                String formattedGroupName = WyHelper.getResourceName(group);
                System.out.println(formattedGroupName);
                if (formattedGroupName.equalsIgnoreCase("patreon_rookie")) {
                    types.add(APIConfig.AccountType.ROOKIE);
                }
                if (formattedGroupName.equalsIgnoreCase("patreon_supernova")) {
                    types.add(APIConfig.AccountType.SUPERNOVA);
                }
                if (formattedGroupName.equalsIgnoreCase("patreon_celestial_dragon")) {
                    types.add(APIConfig.AccountType.CELESTIAL_DRAGON);
                }
                if (!formattedGroupName.equalsIgnoreCase("mine_mine_no_mi_qateam")) continue;
                types.add(APIConfig.AccountType.TESTER);
            }
            return types;
        }
        return null;
    }

    public static boolean isCelestialDragon(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        boolean hasType = PATREONS.get(player.func_110124_au()).contains((Object)APIConfig.AccountType.CELESTIAL_DRAGON);
        return hasType;
    }

    public static boolean isSupernova(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        boolean hasType = PATREONS.get(player.func_110124_au()).contains((Object)APIConfig.AccountType.SUPERNOVA);
        return hasType || WyPatreon.isCelestialDragon(player);
    }

    public static boolean isTester(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        boolean hasType = PATREONS.get(player.func_110124_au()).contains((Object)APIConfig.AccountType.TESTER);
        return hasType;
    }

    public static boolean isRookie(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        boolean hasType = PATREONS.get(player.func_110124_au()).contains((Object)APIConfig.AccountType.ROOKIE);
        return hasType || WyPatreon.isSupernova(player) || WyPatreon.isCelestialDragon(player);
    }

    public static boolean hasPatreonAccess(PlayerEntity player) {
        if (WyPatreon.isDevBuild() && WyPatreon.isCelestialDragon(player)) {
            return true;
        }
        if (WyPatreon.isQABuild() && WyPatreon.isTester(player)) {
            return true;
        }
        return WyPatreon.isEarlyAccessBuild() && WyPatreon.isSupernova(player);
    }

    public static class PatreonEvents {
        private static final Function<ServerPlayerEntity, TimerTask> TASK = player -> new TimerTask((ServerPlayerEntity)player){
            final /* synthetic */ ServerPlayerEntity val$player;
            {
                this.val$player = serverPlayerEntity;
            }

            @Override
            public void run() {
                StringTextComponent message = new StringTextComponent(TextFormatting.BOLD + "" + TextFormatting.RED + "WARNING! \n\n " + TextFormatting.RESET + "You don't have access to this version yet!");
                this.val$player.field_71135_a.func_194028_b((ITextComponent)message);
            }
        };

        @SubscribeEvent
        public void onEntityJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
            if (WyPatreon.isReleaseBuild() || WyPatreon.isDevBuild() && WyDebug.isDebug()) {
                return;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            List patreonLevels = null;
            try {
                patreonLevels = WyPatreon.getPatreonLevel((PlayerEntity)player);
            }
            catch (IOException e) {
                e.printStackTrace();
                new Timer().schedule(TASK.apply(player), 200L);
            }
            if (patreonLevels != null) {
                PATREONS.put(player.func_110124_au(), patreonLevels);
            }
            if (!WyPatreon.hasPatreonAccess((PlayerEntity)player)) {
                new Timer().schedule(TASK.apply(player), 200L);
            }
        }
    }
}

