/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.abilities;

import java.io.Serializable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SAnimeScreamPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public abstract class ChargeableAbility
extends Ability {
    private int chargeTime;
    private int maxChargeTime;
    private boolean isCancelable;
    protected IOnStartCharging onStartChargingEvent = player -> true;
    protected IOnEndCharging onEndChargingEvent = player -> true;
    protected IDuringCharging duringChargingEvent = (player, chargeTime) -> {};

    public ChargeableAbility(String name, APIConfig.AbilityCategory category) {
        super(name, category);
    }

    @Override
    public void use(PlayerEntity player) {
        AbilityUseEvent event;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isOnCooldown() && this.getCooldown() <= 10.0) {
            this.stopCooldown(player);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new AbilityUseEvent(player, this)))) {
            return;
        }
        if (this.isCharging() && this.chargeTime > 0) {
            this.stopCharging(player);
        } else if (this.isOnStandby() && this.onStartChargingEvent.onStartCharging(player)) {
            this.checkAbilityPool(player, Ability.State.CHARGING);
            if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue() && this.getChargedShouts().length > 1) {
                WyNetwork.sendToAllTrackingAndSelf(new SAnimeScreamPacket(player.func_145782_y(), this.getChargedShouts()[0] + "..."), (LivingEntity)player);
            }
            this.chargeTime = this.maxChargeTime;
            this.startCharging(player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
        }
    }

    public void setMaxChargeTime(double seconds) {
        this.chargeTime = this.maxChargeTime = (int)(seconds * 20.0);
    }

    public int getMaxChargeTime() {
        return this.maxChargeTime;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public void setChargeTime(int time) {
        this.chargeTime = time * 20;
    }

    public void setCancelable() {
        this.isCancelable = true;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public void charging(PlayerEntity player) {
        if (!this.canUse(player)) {
            this.setChargeTime(this.getMaxChargeTime());
            this.startCooldown(player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
            return;
        }
        player.field_70170_p.func_217381_Z().func_76320_a(WyHelper.getResourceName(this.getName()));
        if (this.isCharging() && this.chargeTime > 0) {
            --this.chargeTime;
            if (!player.field_70170_p.field_72995_K && !this.isStateForced()) {
                this.duringChargingEvent.duringCharging(player, this.chargeTime);
            }
        } else if (this.isCharging() && this.chargeTime <= 0) {
            this.stopCharging(player);
        }
        player.field_70170_p.func_217381_Z().func_76319_b();
    }

    public void startCharging(PlayerEntity player) {
        this.setState(Ability.State.CHARGING);
    }

    public void stopCharging(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isStateForced() && this.onEndChargingEvent.onEndCharging(player)) {
            this.checkAbilityPool(player, Ability.State.COOLDOWN);
            this.setForcedState(false);
            if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue()) {
                WyNetwork.sendToAllTrackingAndSelf(this.getChargedShouts().length > 1 ? new SAnimeScreamPacket(player.func_145782_y(), this.getChargedShouts()[1]) : new SAnimeScreamPacket(player.func_145782_y(), this.getChargedShouts()[0]), (LivingEntity)player);
            }
            this.chargeTime = this.maxChargeTime;
            this.startCooldown(player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
        }
    }

    public String[] getChargedShouts() {
        String[] stringArray;
        String[] nameSplit = this.getDisplayName().split(" ");
        int midPoint = (int)Math.ceil((double)nameSplit.length / 2.0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < midPoint; ++i) {
            sb.append(nameSplit[i] + " ");
        }
        String firstShout = sb.toString().replaceAll("[:-]", "");
        sb = new StringBuilder();
        for (int i = midPoint; i < nameSplit.length; ++i) {
            sb.append(nameSplit[i] + " ");
        }
        String secondShout = sb.toString().replaceAll("[:-]", "");
        if (secondShout.length() > 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = firstShout;
            stringArray = stringArray2;
            stringArray2[1] = secondShout;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = firstShout;
        }
        return stringArray;
    }

    public static interface IOnEndCharging
    extends Serializable {
        public boolean onEndCharging(PlayerEntity var1);
    }

    public static interface IOnStartCharging
    extends Serializable {
        public boolean onStartCharging(PlayerEntity var1);
    }

    public static interface IDuringCharging
    extends Serializable {
        public void duringCharging(PlayerEntity var1, int var2);
    }
}

