/*
 * Decompiled with CFR 0.152.
 */
package gd.rf.acro.platos.blocks;

import gd.rf.acro.platos.ConfigUtils;
import gd.rf.acro.platos.PlatosTransporters;
import gd.rf.acro.platos.entity.BlockShipEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockControlWheel
extends HorizontalBlock {
    public BlockControlWheel(Block.Properties p_i48339_1_) {
        super(p_i48339_1_);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.MAIN_HAND && !world.field_72995_K) {
            int k;
            int j;
            int i;
            int balloons = Integer.parseInt(ConfigUtils.config.get("balloon"));
            int floats = Integer.parseInt(ConfigUtils.config.get("float"));
            int wheels = Integer.parseInt(ConfigUtils.config.get("wheel"));
            String whitelist = ConfigUtils.config.getOrDefault("whitelist", "false");
            int type = -1;
            int blocks = 0;
            int balances = 0;
            HashMap<String, Integer> used = new HashMap<String, Integer>();
            ListNBT list = new ListNBT();
            CompoundNBT storage = new CompoundNBT();
            ListNBT addons = new ListNBT();
            ArrayList<Integer[]> filtered = new ArrayList<Integer[]>();
            ArrayList accepted = new ArrayList();
            int mposx = 3;
            int mposz = 3;
            int nposx = -3;
            int nposz = -3;
            int mposy = 3;
            int nposy = -3;
            filtered.add(new Integer[]{0, 0, 0});
            while (!filtered.isEmpty()) {
                Integer[] thisPos = (Integer[])filtered.get(0);
                BlockPos gpos = pos.func_177982_a(thisPos[0].intValue(), thisPos[1].intValue(), thisPos[2].intValue());
                for (i = -2; i < 3; ++i) {
                    for (j = -2; j < 3; ++j) {
                        for (k = -2; k < 3; ++k) {
                            if (world.func_180495_p(gpos.func_177982_a(i, j, k)).func_196958_f() || world.func_180495_p(gpos.func_177982_a(i, j, k)).func_177230_c().func_149739_a().contains("ore") || !world.func_180495_p(gpos.func_177982_a(i, j, k)).func_204520_s().func_206888_e() || (!whitelist.equals("true") || !PlatosTransporters.BOAT_MATERIAL.func_199685_a_((Object)world.func_180495_p(gpos.func_177982_a(i, j, k)).func_177230_c())) && (!whitelist.equals("false") || PlatosTransporters.BOAT_MATERIAL_BLACKLIST.func_199685_a_((Object)world.func_180495_p(gpos.func_177982_a(i, j, k)).func_177230_c()))) continue;
                            Integer[] passable = new Integer[]{thisPos[0] + i, thisPos[1] + j, thisPos[2] + k};
                            if (i == 0 && j == 0 && k == 0 || filtered.stream().anyMatch(inside -> Arrays.equals((Object[])inside, (Object[])passable)) || accepted.stream().anyMatch(inside -> Arrays.equals((Object[])inside, (Object[])passable))) continue;
                            filtered.add(passable);
                            if (passable[0] > mposx) {
                                mposx = passable[0];
                            }
                            if (passable[0] < nposx) {
                                nposx = passable[0];
                            }
                            if (passable[1] > mposy) {
                                mposy = passable[1];
                            }
                            if (passable[1] < nposy) {
                                nposy = passable[1];
                            }
                            if (passable[2] > mposz) {
                                mposz = passable[2];
                            }
                            if (passable[2] >= nposz) continue;
                            nposz = passable[2];
                        }
                    }
                }
                accepted.add(filtered.remove(0));
            }
            for (Integer[] integers : accepted) {
                i = integers[0];
                j = integers[1];
                k = integers[2];
                BlockControlWheel.addIfCan(used, world.func_180495_p(pos.func_177982_a(i, j, k)).func_177230_c().func_149739_a(), 1);
                list.add((Object)StringNBT.func_229705_a_((String)(Block.func_196246_j((BlockState)world.func_180495_p(pos.func_177982_a(i, j, k))) + " " + i + " " + j + " " + k)));
                ++blocks;
                if (world.func_180495_p(pos.func_177982_a(i, j, k)).func_177230_c() == Blocks.field_222424_lM) {
                    addons.add((Object)StringNBT.func_229705_a_((String)"engine"));
                }
                if (world.func_180495_p(pos.func_177982_a(i, j, k)).func_177230_c() == Blocks.field_150467_bQ) {
                    addons.add((Object)StringNBT.func_229705_a_((String)"altitude"));
                }
                if (world.func_175625_s(pos.func_177982_a(i, j, k)) != null) {
                    CompoundNBT data = world.func_175625_s(pos.func_177982_a(i, j, k)).func_189515_b(new CompoundNBT());
                    storage.func_218657_a(i + " " + j + " " + k, (INBT)data);
                }
                if (world.func_180495_p(pos.func_177982_a(i, j, k)).func_177230_c() == PlatosTransporters.FLOAT_BLOCK && (type == 0 || type == -1)) {
                    type = 0;
                    balances += floats;
                }
                if (world.func_180495_p(pos.func_177982_a(i, j, k)).func_177230_c() == PlatosTransporters.BALLOON_BLOCK && (type == 1 || type == -1)) {
                    type = 1;
                    balances += balloons;
                }
                if (world.func_180495_p(pos.func_177982_a(i, j, k)).func_177230_c() != PlatosTransporters.WHEEL_BLOCK || type != 2 && type != -1) continue;
                type = 2;
                balances += wheels;
            }
            System.out.println("blocks: " + blocks);
            System.out.println("balances: " + balances);
            if (type == -1) {
                player.func_145747_a((ITextComponent)new StringTextComponent("No wheel/float/balloon found"));
                return ActionResultType.FAIL;
            }
            if (balances < blocks) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Cannot assemble, not enough floats/balloons/wheels"));
                used.keySet().forEach(key -> player.func_145747_a((ITextComponent)new StringTextComponent(key + ": " + used.get(key))));
                player.func_145747_a((ITextComponent)new StringTextComponent("If you believe any of the above blocks was added in error report it on CurseForge!"));
                return ActionResultType.FAIL;
            }
            list.forEach(block -> {
                String[] vv = block.func_150285_a_().split(" ");
                if (world.func_175625_s(pos.func_177982_a(Integer.parseInt(vv[1]), Integer.parseInt(vv[2]), Integer.parseInt(vv[3]))) != null) {
                    IClearable.func_213131_a((Object)world.func_175625_s(pos.func_177982_a(Integer.parseInt(vv[1]), Integer.parseInt(vv[2]), Integer.parseInt(vv[3]))));
                }
                world.func_175656_a(pos.func_177982_a(Integer.parseInt(vv[1]), Integer.parseInt(vv[2]), Integer.parseInt(vv[3])), Blocks.field_150350_a.func_176223_P());
            });
            BlockShipEntity entity = (BlockShipEntity)PlatosTransporters.BLOCK_SHIP_ENTITY_ENTITY_TYPE.func_200721_a(world);
            int offset = 1;
            if (player.func_184586_b(hand).func_77973_b() == PlatosTransporters.LIFT_JACK_ITEM && player.func_184586_b(hand).func_77942_o()) {
                offset = player.func_184586_b(hand).func_77978_p().func_74762_e("off");
            }
            world.func_217376_c((Entity)entity);
            entity.setModel(list, BlockControlWheel.getDirection(state), offset, type, storage, addons);
            if (type == 1) {
                entity.func_189654_d(true);
            }
            entity.func_223102_j(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            player.func_184205_a((Entity)entity, true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)ctx.func_195992_f());
    }

    private static int getDirection(BlockState state) {
        if (state.func_177229_b((IProperty)BlockStateProperties.field_208157_J) == Direction.EAST) {
            return 270;
        }
        if (state.func_177229_b((IProperty)BlockStateProperties.field_208157_J) == Direction.SOUTH) {
            return 180;
        }
        if (state.func_177229_b((IProperty)BlockStateProperties.field_208157_J) == Direction.WEST) {
            return 90;
        }
        return 0;
    }

    private static HashMap<String, Integer> addIfCan(HashMap<String, Integer> input, String key, int mod) {
        if (input.containsKey(key)) {
            input.put(key, input.get(key) + mod);
        } else {
            input.put(key, mod);
        }
        return input;
    }
}

