/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.text.WordUtils;
import org.objectweb.asm.Type;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

public final class ModuleFinder {
    private static final Type LOAD_MODULE_TYPE = Type.getType(LoadModule.class);
    private Map<Class<? extends Module>, Module> foundModules = new HashMap<Class<? extends Module>, Module>();

    public void findModules() {
        ModFileScanData scanData = ModList.get().getModFileById("quark").getFile().getScanResult();
        scanData.getAnnotations().stream().filter(annotationData -> LOAD_MODULE_TYPE.equals((Object)annotationData.getAnnotationType())).sorted((d1, d2) -> d1.getClassType().getClassName().compareTo(d2.getClassType().getClassName())).forEach(this::loadModule);
    }

    private void loadModule(ModFileScanData.AnnotationData target) {
        try {
            String mod;
            Class<?> clazz = Class.forName(target.getClassType().getClassName());
            Module moduleObj = (Module)clazz.newInstance();
            Map vals = target.getAnnotationData();
            if (vals.containsKey("requiredMod") && (mod = (String)vals.get("requiredMod")) != null && !mod.isEmpty() && !ModList.get().isLoaded(mod)) {
                moduleObj.missingDep = true;
            }
            moduleObj.displayName = vals.containsKey("name") ? (String)vals.get("name") : WordUtils.capitalizeFully((String)clazz.getSimpleName().replaceAll("Module$", "").replaceAll("(?<=.)([A-Z])", " $1"));
            moduleObj.lowercaseName = moduleObj.displayName.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            if (vals.containsKey("description")) {
                moduleObj.description = (String)vals.get("description");
            }
            if (vals.containsKey("antiOverlap")) {
                moduleObj.antiOverlap = (List)vals.get("antiOverlap");
            }
            if (vals.containsKey("hasSubscriptions")) {
                moduleObj.hasSubscriptions = (Boolean)vals.get("hasSubscriptions");
            }
            if (vals.containsKey("subscribeOn")) {
                EnumSet<Dist> subscribeTargets = EnumSet.noneOf(Dist.class);
                List holders = (List)vals.get("subscribeOn");
                for (ModAnnotation.EnumHolder holder : holders) {
                    subscribeTargets.add(Dist.valueOf((String)holder.getValue()));
                }
                moduleObj.subscriptionTarget = Lists.newArrayList(subscribeTargets);
            }
            if (vals.containsKey("enabledByDefault")) {
                moduleObj.enabledByDefault = (Boolean)vals.get("enabledByDefault");
            }
            ModuleCategory category = this.getOrMakeCategory((ModAnnotation.EnumHolder)vals.get("category"));
            category.addModule(moduleObj);
            this.foundModules.put(clazz, moduleObj);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to load Module " + target.toString(), e);
        }
    }

    private ModuleCategory getOrMakeCategory(ModAnnotation.EnumHolder category) {
        return ModuleCategory.valueOf(category.getValue());
    }

    public Map<Class<? extends Module>, Module> getFoundModules() {
        return this.foundModules;
    }
}

