/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.block;

import com.google.common.base.Supplier;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.block.VariantChestBlock;
import vazkii.quark.building.module.VariantChestsModule;
import vazkii.quark.building.tile.VariantTrappedChestTileEntity;

@OnlyIn(value=Dist.CLIENT, _interface=IBlockItemProvider.class)
public class VariantTrappedChestBlock
extends ChestBlock
implements IBlockItemProvider,
IQuarkBlock,
VariantChestsModule.IChestTextureProvider {
    public final String type;
    private final Module module;
    private BooleanSupplier enabledSupplier = () -> true;
    private String path;

    public VariantTrappedChestBlock(String type, Module module, Supplier<TileEntityType<? extends ChestTileEntity>> supplier, Block.Properties props) {
        super(props, supplier);
        RegistryHelper.registerBlock((Block)this, (String)(type + "_trapped_chest"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78028_d);
        this.type = type;
        this.module = module;
        this.path = (this instanceof Compat ? "compat/" : "") + type + "/";
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.module.enabled || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public VariantTrappedChestBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.module;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new VariantTrappedChestTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        VariantChestBlock.setISTER(props, block);
        return new BlockItem(block, props);
    }

    @Override
    public String getChestTexturePath() {
        return "model/chest/" + this.path;
    }

    @Override
    public boolean isTrap() {
        return true;
    }

    protected Stat<ResourceLocation> func_196310_d() {
        return Stats.field_199092_j.func_199076_b((Object)Stats.field_188089_W);
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return MathHelper.func_76125_a((int)ChestTileEntity.func_195481_a((IBlockReader)p_180656_2_, (BlockPos)p_180656_3_), (int)0, (int)15);
    }

    public int func_176211_b(BlockState p_176211_1_, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        return p_176211_4_ == Direction.UP ? p_176211_1_.func_185911_a(p_176211_2_, p_176211_3_, p_176211_4_) : 0;
    }

    public static class Compat
    extends VariantTrappedChestBlock {
        public Compat(String type, String mod, Module module, Supplier<TileEntityType<? extends ChestTileEntity>> supplier, Block.Properties props) {
            super(type, module, supplier, props);
            this.setCondition(() -> ModList.get().isLoaded(mod));
        }
    }
}

