/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import vazkii.quark.automation.client.render.PistonTileEntityRenderer;
import vazkii.quark.oddities.tile.MagnetizedBlockTileEntity;

@OnlyIn(value=Dist.CLIENT)
public class MagnetizedBlockTileEntityRenderer
extends TileEntityRenderer<MagnetizedBlockTileEntity> {
    private BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();

    public MagnetizedBlockTileEntityRenderer(TileEntityRendererDispatcher d) {
        super(d);
    }

    public void render(MagnetizedBlockTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        if (world != null) {
            BlockPos truepos = tileEntityIn.func_174877_v();
            BlockPos blockpos = truepos.func_177972_a(tileEntityIn.getFacing().func_176734_d());
            BlockState blockstate = tileEntityIn.getMagnetState();
            if (!blockstate.func_196958_f() && !(tileEntityIn.getProgress(partialTicks) >= 1.0f)) {
                Vec3d offset;
                TileEntity subTile = tileEntityIn.getSubTile();
                if (PistonTileEntityRenderer.renderTESafely(world, truepos, blockstate, subTile, tileEntityIn, partialTicks, offset = new Vec3d((double)tileEntityIn.getOffsetX(partialTicks), (double)tileEntityIn.getOffsetY(partialTicks), (double)tileEntityIn.getOffsetZ(partialTicks)), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn)) {
                    return;
                }
                BlockModelRenderer.func_211847_a();
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                if (blockstate.func_177230_c() == Blocks.field_150332_K && tileEntityIn.getProgress(partialTicks) <= 4.0f) {
                    blockstate = (BlockState)blockstate.func_206870_a((IProperty)PistonHeadBlock.field_176327_M, (Comparable)Boolean.valueOf(true));
                    this.renderStateModel(blockpos, blockstate, matrixStackIn, bufferIn, world, false, combinedOverlayIn);
                } else {
                    this.renderStateModel(blockpos, blockstate, matrixStackIn, bufferIn, world, false, combinedOverlayIn);
                }
                matrixStackIn.func_227865_b_();
                BlockModelRenderer.func_210266_a();
            }
        }
    }

    private void renderStateModel(BlockPos p_228876_1_, BlockState p_228876_2_, MatrixStack p_228876_3_, IRenderTypeBuffer p_228876_4_, World p_228876_5_, boolean p_228876_6_, int p_228876_7_) {
        RenderType.func_228661_n_().stream().filter(t -> RenderTypeLookup.canRenderInLayer((BlockState)p_228876_2_, (RenderType)t)).forEach(rendertype -> {
            ForgeHooksClient.setRenderLayer((RenderType)rendertype);
            IVertexBuilder ivertexbuilder = p_228876_4_.getBuffer(rendertype);
            if (this.blockRenderer == null) {
                this.blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            }
            this.blockRenderer.func_175019_b().func_228802_a_((ILightReader)p_228876_5_, this.blockRenderer.func_184389_a(p_228876_2_), p_228876_2_, p_228876_1_, p_228876_3_, ivertexbuilder, p_228876_6_, new Random(), p_228876_2_.func_209533_a(p_228876_1_), p_228876_7_);
        });
        ForgeHooksClient.setRenderLayer(null);
    }
}

