/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.tile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.building.block.CandleBlock;
import vazkii.quark.oddities.container.EnchantmentMatrix;
import vazkii.quark.oddities.container.MatrixEnchantingContainer;
import vazkii.quark.oddities.module.MatrixEnchantingModule;
import vazkii.quark.oddities.tile.BaseEnchantingTableTile;

public class MatrixEnchantingTableTileEntity
extends BaseEnchantingTableTile
implements INamedContainerProvider {
    public static final int OPER_ADD = 0;
    public static final int OPER_PLACE = 1;
    public static final int OPER_REMOVE = 2;
    public static final int OPER_ROTATE = 3;
    public static final int OPER_MERGE = 4;
    public static final String TAG_STACK_MATRIX = "quark:enchantingMatrix";
    private static final String TAG_MATRIX = "matrix";
    private static final String TAG_MATRIX_UUID_LESS = "uuidLess";
    private static final String TAG_MATRIX_UUID_MOST = "uuidMost";
    private static final String TAG_CHARGE = "charge";
    public EnchantmentMatrix matrix;
    private boolean matrixDirty = false;
    public boolean clientMatrixDirty = false;
    private UUID matrixId;
    public final Map<Enchantment, Integer> influences = new HashMap<Enchantment, Integer>();
    public int bookshelfPower;
    public int enchantability;
    public int charge;

    public MatrixEnchantingTableTileEntity() {
        super(MatrixEnchantingModule.tileEntityType);
    }

    @Override
    public void func_73660_a() {
        ItemStack lapis;
        super.func_73660_a();
        ItemStack item = this.func_70301_a(0);
        if (item.func_190926_b()) {
            this.matrix = null;
            this.matrixDirty = true;
        } else {
            this.loadMatrix(item);
            if (this.field_145850_b.func_82737_E() % 20L == 0L || this.matrixDirty) {
                this.updateEnchantPower();
            }
        }
        if (this.charge <= 0 && !this.field_145850_b.field_72995_K && !(lapis = this.func_70301_a(1)).func_190926_b()) {
            lapis.func_190918_g(1);
            this.charge += MatrixEnchantingModule.chargePerLapis;
            this.sync();
        }
        if (this.matrixDirty) {
            this.makeOutput();
            this.matrixDirty = false;
        }
    }

    public void onOperation(PlayerEntity player, int operation, int arg0, int arg1, int arg2) {
        if (this.matrix == null) {
            return;
        }
        switch (operation) {
            case 0: {
                this.apply(m -> this.generateAndPay((EnchantmentMatrix)m, player));
                break;
            }
            case 1: {
                this.apply(m -> m.place(arg0, arg1, arg2));
                break;
            }
            case 2: {
                this.apply(m -> m.remove(arg0));
                break;
            }
            case 3: {
                this.apply(m -> m.rotate(arg0));
                break;
            }
            case 4: {
                this.apply(m -> m.merge(arg0, arg1));
            }
        }
    }

    private void apply(Predicate<EnchantmentMatrix> oper) {
        if (oper.test(this.matrix)) {
            ItemStack item = this.func_70301_a(0);
            this.commitMatrix(item);
        }
    }

    private boolean generateAndPay(EnchantmentMatrix matrix, PlayerEntity player) {
        if (matrix.canGeneratePiece(this.bookshelfPower, this.enchantability) && matrix.validateXp(player, this.bookshelfPower)) {
            boolean creative = player.func_184812_l_();
            int cost = matrix.getNewPiecePrice();
            if ((this.charge > 0 || creative) && matrix.generatePiece(this.influences, this.bookshelfPower) && !creative) {
                player.func_82242_a(-cost);
                this.charge = Math.max(this.charge - 1, 0);
            }
        }
        return true;
    }

    private void makeOutput() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_70299_a(2, ItemStack.field_190927_a);
        ItemStack in = this.func_70301_a(0);
        if (!in.func_190926_b() && this.matrix != null && !this.matrix.placedPieces.isEmpty()) {
            ItemStack out = in.func_77946_l();
            boolean book = false;
            if (out.func_77973_b() == Items.field_151122_aG) {
                out = new ItemStack((IItemProvider)Items.field_151134_bR);
                book = true;
            }
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            Iterator<Object> iterator = this.matrix.placedPieces.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                EnchantmentMatrix.Piece p = this.matrix.pieces.get(n);
                if (p == null || p.enchant == null) continue;
                for (Enchantment o : enchantments.keySet()) {
                    if (o != p.enchant && p.enchant.func_191560_c(o) && o.func_191560_c(p.enchant)) continue;
                    return;
                }
                enchantments.put(p.enchant, p.level);
            }
            if (book) {
                for (Map.Entry entry : enchantments.entrySet()) {
                    EnchantedBookItem.func_92115_a((ItemStack)out, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                }
            } else {
                EnchantmentHelper.func_82782_a(enchantments, (ItemStack)out);
                ItemNBTHelper.getNBT((ItemStack)out).func_82580_o(TAG_STACK_MATRIX);
            }
            this.func_70299_a(2, out);
        }
    }

    private void loadMatrix(ItemStack stack) {
        if (this.matrix == null || this.matrix.target != stack) {
            if (this.matrix != null) {
                this.matrixDirty = true;
            }
            this.matrix = null;
            if (stack.func_77956_u()) {
                CompoundNBT cmp;
                this.matrix = new EnchantmentMatrix(stack, this.field_145850_b.field_73012_v);
                this.matrixDirty = true;
                this.makeUUID();
                if (ItemNBTHelper.verifyExistence((ItemStack)stack, (String)TAG_STACK_MATRIX) && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_STACK_MATRIX, (boolean)true)) != null) {
                    this.matrix.readFromNBT(cmp);
                }
            }
        }
    }

    private void commitMatrix(ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        CompoundNBT cmp = new CompoundNBT();
        this.matrix.writeToNBT(cmp);
        ItemNBTHelper.setCompound((ItemStack)stack, (String)TAG_STACK_MATRIX, (CompoundNBT)cmp);
        this.matrixDirty = true;
        this.makeUUID();
        this.sync();
    }

    private void makeUUID() {
        if (!this.field_145850_b.field_72995_K) {
            this.matrixId = UUID.randomUUID();
        }
    }

    private void updateEnchantPower() {
        ItemStack item = this.func_70301_a(0);
        this.influences.clear();
        if (item.func_190926_b()) {
            return;
        }
        this.enchantability = item.func_77973_b().getItemEnchantability(item);
        boolean allowWater = MatrixEnchantingModule.allowUnderwaterEnchanting;
        float power = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (!this.isAirGap(j, k, allowWater)) continue;
                power += this.getEnchantPowerAt(this.field_145850_b, this.field_174879_c.func_177982_a(k * 2, 0, j * 2));
                power += this.getEnchantPowerAt(this.field_145850_b, this.field_174879_c.func_177982_a(k * 2, 1, j * 2));
                if (k == 0 || j == 0) continue;
                power += this.getEnchantPowerAt(this.field_145850_b, this.field_174879_c.func_177982_a(k * 2, 0, j));
                power += this.getEnchantPowerAt(this.field_145850_b, this.field_174879_c.func_177982_a(k * 2, 1, j));
                power += this.getEnchantPowerAt(this.field_145850_b, this.field_174879_c.func_177982_a(k, 0, j * 2));
                power += this.getEnchantPowerAt(this.field_145850_b, this.field_174879_c.func_177982_a(k, 1, j * 2));
            }
        }
        this.bookshelfPower = Math.min((int)power, MatrixEnchantingModule.maxBookshelves);
    }

    private boolean isAirGap(int j, int k, boolean allowWater) {
        if (j != 0 || k != 0) {
            BlockPos test = this.field_174879_c.func_177982_a(k, 0, j);
            BlockPos testUp = test.func_177984_a();
            return (this.field_145850_b.func_175623_d(test) || allowWater && this.field_145850_b.func_180495_p(test).func_177230_c() == Blocks.field_150355_j) && (this.field_145850_b.func_175623_d(testUp) || allowWater && this.field_145850_b.func_180495_p(testUp).func_177230_c() == Blocks.field_150355_j);
        }
        return false;
    }

    private float getEnchantPowerAt(World world, BlockPos pos) {
        Block block;
        BlockState state = world.func_180495_p(pos);
        if (MatrixEnchantingModule.allowInfluencing && (block = state.func_177230_c()) instanceof CandleBlock) {
            DyeColor ord = ((CandleBlock)state.func_177230_c()).color;
            List<Enchantment> influencedEnchants = MatrixEnchantingModule.candleInfluences.get(ord);
            for (Enchantment e : influencedEnchants) {
                int curr = this.influences.getOrDefault(e, 0);
                if (curr >= MatrixEnchantingModule.influenceMax) continue;
                this.influences.put(e, curr + 1);
            }
        }
        return state.getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public void writeSharedNBT(CompoundNBT cmp) {
        super.writeSharedNBT(cmp);
        CompoundNBT matrixCmp = new CompoundNBT();
        if (this.matrix != null) {
            this.matrix.writeToNBT(matrixCmp);
            cmp.func_218657_a(TAG_MATRIX, (INBT)matrixCmp);
            if (this.matrixId != null) {
                cmp.func_74772_a(TAG_MATRIX_UUID_LESS, this.matrixId.getLeastSignificantBits());
                cmp.func_74772_a(TAG_MATRIX_UUID_MOST, this.matrixId.getMostSignificantBits());
            }
        }
        cmp.func_74768_a(TAG_CHARGE, this.charge);
    }

    public void readSharedNBT(CompoundNBT cmp) {
        super.readSharedNBT(cmp);
        if (cmp.func_74764_b(TAG_MATRIX)) {
            long least = cmp.func_74763_f(TAG_MATRIX_UUID_LESS);
            long most = cmp.func_74763_f(TAG_MATRIX_UUID_MOST);
            UUID newId = new UUID(most, least);
            if (!newId.equals(this.matrixId)) {
                CompoundNBT matrixCmp = cmp.func_74775_l(TAG_MATRIX);
                this.matrixId = newId;
                this.matrix = new EnchantmentMatrix(this.func_70301_a(0), new Random());
                this.matrix.readFromNBT(matrixCmp);
            }
            this.clientMatrixDirty = true;
        } else {
            this.matrix = null;
        }
        this.charge = cmp.func_74762_e(TAG_CHARGE);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new MatrixEnchantingContainer(id, inv, this);
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }
}

