/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.client.emote;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.aurelienribon.tweenengine.TweenAccessor;

@OnlyIn(value=Dist.CLIENT)
public class ModelAccessor
implements TweenAccessor<BipedModel<?>> {
    public static final ModelAccessor INSTANCE = new ModelAccessor();
    private static final int ROT_X = 0;
    private static final int ROT_Y = 1;
    private static final int ROT_Z = 2;
    protected static final int MODEL_PROPS = 3;
    protected static final int BODY_PARTS = 7;
    protected static final int STATE_COUNT = 21;
    public static final int HEAD = 0;
    public static final int BODY = 3;
    public static final int RIGHT_ARM = 6;
    public static final int LEFT_ARM = 9;
    public static final int RIGHT_LEG = 12;
    public static final int LEFT_LEG = 15;
    public static final int MODEL = 18;
    public static final int HEAD_X = 0;
    public static final int HEAD_Y = 1;
    public static final int HEAD_Z = 2;
    public static final int BODY_X = 3;
    public static final int BODY_Y = 4;
    public static final int BODY_Z = 5;
    public static final int RIGHT_ARM_X = 6;
    public static final int RIGHT_ARM_Y = 7;
    public static final int RIGHT_ARM_Z = 8;
    public static final int LEFT_ARM_X = 9;
    public static final int LEFT_ARM_Y = 10;
    public static final int LEFT_ARM_Z = 11;
    public static final int RIGHT_LEG_X = 12;
    public static final int RIGHT_LEG_Y = 13;
    public static final int RIGHT_LEG_Z = 14;
    public static final int LEFT_LEG_X = 15;
    public static final int LEFT_LEG_Y = 16;
    public static final int LEFT_LEG_Z = 17;
    public static final int MODEL_X = 18;
    public static final int MODEL_Y = 19;
    public static final int MODEL_Z = 20;
    private final Map<BipedModel<?>, float[]> MODEL_VALUES = new WeakHashMap();

    public void resetModel(BipedModel<?> model) {
        this.MODEL_VALUES.remove(model);
    }

    @Override
    public int getValues(BipedModel<?> target, int tweenType, float[] returnValues) {
        int axis = tweenType % 3;
        int bodyPart = tweenType - axis;
        if (bodyPart == 18) {
            if (!this.MODEL_VALUES.containsKey(target)) {
                returnValues[0] = 0.0f;
                return 1;
            }
            float[] values = this.MODEL_VALUES.get(target);
            returnValues[0] = values[axis];
            return 1;
        }
        ModelRenderer model = this.getBodyPart(target, bodyPart);
        if (model == null) {
            return 0;
        }
        switch (axis) {
            case 0: {
                returnValues[0] = model.field_78795_f;
                break;
            }
            case 1: {
                returnValues[0] = model.field_78796_g;
                break;
            }
            case 2: {
                returnValues[0] = model.field_78808_h;
            }
        }
        return 1;
    }

    private ModelRenderer getBodyPart(BipedModel<?> model, int part) {
        switch (part) {
            case 0: {
                return model.field_78116_c;
            }
            case 3: {
                return model.field_78115_e;
            }
            case 6: {
                return model.field_178723_h;
            }
            case 9: {
                return model.field_178724_i;
            }
            case 12: {
                return model.field_178721_j;
            }
            case 15: {
                return model.field_178722_k;
            }
        }
        return null;
    }

    @Override
    public void setValues(BipedModel<?> target, int tweenType, float[] newValues) {
        int axis = tweenType % 3;
        int bodyPart = tweenType - axis;
        if (bodyPart == 18) {
            float[] values = this.MODEL_VALUES.get(target);
            if (values == null) {
                values = new float[3];
                this.MODEL_VALUES.put(target, values);
            }
            values[axis] = newValues[0];
            return;
        }
        ModelRenderer model = this.getBodyPart(target, bodyPart);
        this.messWithModel(target, model, axis, newValues[0]);
    }

    private void messWithModel(BipedModel<?> biped, ModelRenderer part, int axis, float val) {
        this.setPartAxis(part, axis, val);
        if (biped instanceof PlayerModel) {
            this.messWithPlayerModel((PlayerModel)biped, part, axis, val);
        }
    }

    private void messWithPlayerModel(PlayerModel<?> biped, ModelRenderer part, int axis, float val) {
        if (part == biped.field_78116_c) {
            this.setPartAxis(biped.field_178720_f, axis, val);
        } else if (part == biped.field_178724_i) {
            this.setPartAxis(biped.field_178734_a, axis, val);
        } else if (part == biped.field_178723_h) {
            this.setPartAxis(biped.field_178732_b, axis, val);
        } else if (part == biped.field_178722_k) {
            this.setPartAxis(biped.field_178733_c, axis, val);
        } else if (part == biped.field_178721_j) {
            this.setPartAxis(biped.field_178731_d, axis, val);
        } else if (part == biped.field_78115_e) {
            this.setPartAxis(biped.field_178730_v, axis, val);
        }
    }

    private void setPartAxis(ModelRenderer part, int axis, float val) {
        if (part == null) {
            return;
        }
        switch (axis) {
            case 0: {
                part.field_78795_f = val;
                break;
            }
            case 1: {
                part.field_78796_g = val;
                break;
            }
            case 2: {
                part.field_78808_h = val;
            }
        }
    }
}

