/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="abnormals_core")
public class LootInjectionRegistry {
    private static final Map<Set<ResourceLocation>, LootPool> POOLS = Maps.newHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInjectLoot(LootTableLoadEvent event) {
        POOLS.keySet().forEach(locations -> {
            if (locations.contains(event.getName())) {
                event.getTable().addPool(POOLS.get(locations));
            }
        });
    }

    public static class LootInjector {
        private final String modId;

        public LootInjector(String modId) {
            this.modId = modId;
        }

        public synchronized void registerLootInjection(LootPool pool, ResourceLocation ... locations) {
            POOLS.put(Sets.newHashSet((Object[])locations), pool);
        }

        public LootPool buildLootBool(String name, int weight, int quality) {
            return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(this.modId, "injections/" + name)).func_216086_a(weight).func_216085_b(quality)).name(name).func_216044_b();
        }
    }
}

