/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import net.optifine.Config;
import net.optifine.http.FileUploadThread;
import net.optifine.http.IFileUploadListener;
import net.optifine.shaders.Shaders;

public class CrashReporter {
    public static void onCrashReport(h crashReport, i category) {
        try {
            Throwable cause = crashReport.b();
            if (cause == null) {
                return;
            }
            if (cause.getClass().getName().contains(".fml.client.SplashProgress")) {
                return;
            }
            if (cause.getClass() == Throwable.class) {
                return;
            }
            CrashReporter.extendCrashReport(category);
            dbr settings = Config.getGameSettings();
            if (settings == null) {
                return;
            }
            if (!settings.R) {
                return;
            }
            String url = "http://optifine.net/crashReport";
            String reportStr = CrashReporter.makeReport(crashReport);
            byte[] content = reportStr.getBytes("ASCII");
            IFileUploadListener listener = new IFileUploadListener(){

                @Override
                public void fileUploadFinished(String url, byte[] content, Throwable exception) {
                }
            };
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("OF-Version", Config.getVersion());
            headers.put("OF-Summary", CrashReporter.makeSummary(crashReport));
            FileUploadThread fut = new FileUploadThread(url, headers, content, listener);
            fut.setPriority(10);
            fut.start();
            Thread.sleep(1000L);
        }
        catch (Exception e2) {
            Config.dbg(e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    private static String makeReport(h crashReport) {
        StringBuffer sb2 = new StringBuffer();
        sb2.append("OptiFineVersion: " + Config.getVersion() + "\n");
        sb2.append("Summary: " + CrashReporter.makeSummary(crashReport) + "\n");
        sb2.append("\n");
        sb2.append(crashReport.e());
        sb2.append("\n");
        return sb2.toString();
    }

    private static String makeSummary(h crashReport) {
        Throwable t2 = crashReport.b();
        if (t2 == null) {
            return "Unknown";
        }
        StackTraceElement[] traces = t2.getStackTrace();
        String firstTrace = "unknown";
        if (traces.length > 0) {
            firstTrace = traces[0].toString().trim();
        }
        String sum = t2.getClass().getName() + ": " + t2.getMessage() + " (" + crashReport.a() + ") [" + firstTrace + "]";
        return sum;
    }

    public static void extendCrashReport(i cat) {
        cat.a("OptiFine Version", (Object)Config.getVersion());
        cat.a("OptiFine Build", (Object)Config.getBuild());
        if (Config.getGameSettings() != null) {
            cat.a("Render Distance Chunks", (Object)("" + Config.getChunkViewDistance()));
            cat.a("Mipmaps", (Object)("" + Config.getMipmapLevels()));
            cat.a("Anisotropic Filtering", (Object)("" + Config.getAnisotropicFilterLevel()));
            cat.a("Antialiasing", (Object)("" + Config.getAntialiasingLevel()));
            cat.a("Multitexture", (Object)("" + Config.isMultiTexture()));
        }
        cat.a("Shaders", (Object)("" + Shaders.getShaderPackName()));
        cat.a("OpenGlVersion", (Object)("" + Config.openGlVersion));
        cat.a("OpenGlRenderer", (Object)("" + Config.openGlRenderer));
        cat.a("OpenGlVendor", (Object)("" + Config.openGlVendor));
        cat.a("CpuCount", (Object)("" + Config.getAvailableProcessors()));
    }
}

