/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.minecraft.world.level.ColorResolver;
import net.optifine.BlockPosM;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements bje {
    private final dti chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private byj[] blockStates;
    private bkt[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(byj.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(bkt.class, 16);

    public ChunkCacheOF(dti chunkCache, fk posFromIn, fk posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.o() - subIn >> 4;
        int minChunkY = posFromIn.p() - subIn >> 4;
        int minChunkZ = posFromIn.q() - subIn >> 4;
        int maxChunkX = posToIn.o() + subIn >> 4;
        int maxChunkY = posToIn.p() + subIn >> 4;
        int maxChunkZ = posToIn.q() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(fk pos) {
        int dx = pos.o() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.p() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.q() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(bkf type, fk pos) {
        return this.chunkCache.a(type, pos);
    }

    public byj d_(fk pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.d_(pos);
        }
        byj iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.d_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (byj[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (bkt[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        cal chunk = this.chunkCache.getChunk(1, 1);
        BlockPosM pos = new BlockPosM();
        for (int y = 16; y < 32; ++y) {
            int dy = y * this.sizeXZ;
            for (int z = 16; z < 32; ++z) {
                int dz = z * this.sizeX;
                for (int x = 16; x < 32; ++x) {
                    byj bs;
                    pos.setXyz(this.posX + x, this.posY + y, this.posZ + z);
                    int index = dy + dz + x;
                    this.blockStates[index] = bs = chunk.d_((fk)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free(this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free(this.blockStates);
        this.blockStates = null;
        cacheBiomes.free(this.biomes);
        this.biomes = null;
    }

    public int[] getCombinedLights() {
        return this.combinedLights;
    }

    public bkt getBiome(fk pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        bkt biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public bwl c(fk pos) {
        return this.chunkCache.a(pos, cal.a.c);
    }

    public bwl getTileEntity(fk pos, cal.a type) {
        return this.chunkCache.a(pos, type);
    }

    public boolean f(fk pos) {
        return this.chunkCache.f(pos);
    }

    public coj b(fk pos) {
        return this.d_(pos).p();
    }

    public int a(fk blockPosIn, ColorResolver colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public coa e() {
        return this.chunkCache.e();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }
}

