/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AccessFixer {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void fixMemberAccess(ClassNode classOld, ClassNode classNew) {
        List fieldsOld = classOld.fields;
        List fieldsNew = classNew.fields;
        Map<String, FieldNode> mapFieldsOld = AccessFixer.getMapFields(fieldsOld);
        for (FieldNode fieldNew : fieldsNew) {
            String idNew = fieldNew.name;
            FieldNode fieldOld = mapFieldsOld.get(idNew);
            if (fieldOld == null || fieldNew.access == fieldOld.access) continue;
            fieldNew.access = AccessFixer.combineAccess(fieldNew.access, fieldOld.access);
        }
        List methodsOld = classOld.methods;
        List methodsNew = classNew.methods;
        Map<String, MethodNode> mapMethodsOld = AccessFixer.getMapMethods(methodsOld);
        HashSet<String> privateChanged = new HashSet<String>();
        for (MethodNode methodNew : methodsNew) {
            String idNew = String.valueOf(methodNew.name) + methodNew.desc;
            MethodNode methodOld = mapMethodsOld.get(idNew);
            if (methodOld == null || methodNew.access == methodOld.access) continue;
            int accessPrev = methodNew.access;
            methodNew.access = AccessFixer.combineAccess(methodNew.access, methodOld.access);
            if (!AccessFixer.isSet(accessPrev, 2) || AccessFixer.isSet(methodNew.access, 2) || AccessFixer.isSet(methodNew.access, 8) || methodNew.name.equals("<init>")) continue;
            privateChanged.add(String.valueOf(methodNew.name) + methodNew.desc);
        }
        if (!privateChanged.isEmpty()) {
            ArrayList changed = new ArrayList();
            classNew.methods.forEach(mn -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(mn.instructions.iterator(), 16), false).filter(i2 -> i2.getOpcode() == 183).map(MethodInsnNode.class::cast).filter(m2 -> privateChanged.contains(String.valueOf(m2.name) + m2.desc)).forEach(m2 -> {
                m2.setOpcode(182);
                changed.add(m2);
            }));
        }
        List innerClassesOld = classOld.innerClasses;
        List innerClassesNew = classNew.innerClasses;
        Map<String, InnerClassNode> mapInnerClassesOld = AccessFixer.getMapInnerClasses(innerClassesOld);
        for (InnerClassNode innerClassNew : innerClassesNew) {
            int accessNew;
            String idNew = innerClassNew.name;
            InnerClassNode innerClassOld = mapInnerClassesOld.get(idNew);
            if (innerClassOld == null || innerClassNew.access == innerClassOld.access) continue;
            innerClassNew.access = accessNew = AccessFixer.combineAccess(innerClassNew.access, innerClassOld.access);
        }
        if (classNew.access != classOld.access) {
            int accessClassNew;
            classNew.access = accessClassNew = AccessFixer.combineAccess(classNew.access, classOld.access);
        }
    }

    private static int combineAccess(int access, int access2) {
        if (access == access2) {
            return access;
        }
        int MASK_ACCESS = 7;
        int accessClean = access & ~MASK_ACCESS;
        if (!AccessFixer.isSet(access, 16) || !AccessFixer.isSet(access2, 16)) {
            accessClean &= 0xFFFFFFEF;
        }
        if (AccessFixer.isSet(access, 1) || AccessFixer.isSet(access2, 1)) {
            return accessClean | 1;
        }
        if (AccessFixer.isSet(access, 4) || AccessFixer.isSet(access2, 4)) {
            return accessClean | 4;
        }
        if (AccessFixer.isSet(access, 2) || AccessFixer.isSet(access2, 2)) {
            return accessClean | 2;
        }
        return accessClean;
    }

    private static boolean isSet(int access, int flag) {
        return (access & flag) != 0;
    }

    public static Map<String, FieldNode> getMapFields(List<FieldNode> fields) {
        LinkedHashMap<String, FieldNode> map = new LinkedHashMap<String, FieldNode>();
        for (FieldNode fieldNode : fields) {
            String id = fieldNode.name;
            map.put(id, fieldNode);
        }
        return map;
    }

    public static Map<String, MethodNode> getMapMethods(List<MethodNode> methods) {
        LinkedHashMap<String, MethodNode> map = new LinkedHashMap<String, MethodNode>();
        for (MethodNode methodNode : methods) {
            String id = String.valueOf(methodNode.name) + methodNode.desc;
            map.put(id, methodNode);
        }
        return map;
    }

    public static Map<String, InnerClassNode> getMapInnerClasses(List<InnerClassNode> innerClasses) {
        LinkedHashMap<String, InnerClassNode> map = new LinkedHashMap<String, InnerClassNode>();
        for (InnerClassNode innerClassNode : innerClasses) {
            String id = innerClassNode.name;
            map.put(id, innerClassNode);
        }
        return map;
    }

    private static String toString(int access) {
        StringBuffer sb2 = new StringBuffer();
        if (AccessFixer.isSet(access, 1)) {
            AccessFixer.addToBuffer(sb2, "public", " ");
        }
        if (AccessFixer.isSet(access, 4)) {
            AccessFixer.addToBuffer(sb2, "protected", " ");
        }
        if (AccessFixer.isSet(access, 2)) {
            AccessFixer.addToBuffer(sb2, "private", " ");
        }
        if (AccessFixer.isSet(access, 16)) {
            AccessFixer.addToBuffer(sb2, "final", " ");
        }
        return sb2.toString();
    }

    private static void addToBuffer(StringBuffer sb2, String val, String separator) {
        if (sb2.length() > 0) {
            sb2.append(separator);
        }
        sb2.append(val);
    }
}

