/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.islands;

import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.OceanLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import xyz.pixelatedw.islands.config.CommonConfig;
import xyz.pixelatedw.islands.layers.IslandMasterLayer;
import xyz.pixelatedw.islands.layers.IslandMixOceansLayer;
import xyz.pixelatedw.islands.layers.IslandShoreLayer;

public class IslandLayerProvider {
    private static <A extends IArea, R extends IExtendedNoiseRandom<A>> IAreaFactory<A> setup(LongFunction<R> randomProvider) {
        IAreaFactory islandFactory = IslandMasterLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)randomProvider.apply(1000L));
        int min = CommonConfig.INSTANCE.getIslandMinSize();
        int max = CommonConfig.INSTANCE.getIslandMaxSize();
        int maxX = Math.max(max - min, 1);
        int size = ((IExtendedNoiseRandom)randomProvider.apply(1000L)).func_202696_a(maxX) + min;
        for (int islandSize = 0; islandSize <= size; ++islandSize) {
            islandFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(1000L), islandFactory);
        }
        islandFactory = IslandShoreLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(10L), islandFactory);
        islandFactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(1000L), islandFactory);
        islandFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(1000L), islandFactory);
        IAreaFactory oceanFactory = OceanLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)randomProvider.apply(2L));
        for (int oceanZoom = 0; oceanZoom <= 6; ++oceanZoom) {
            oceanFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)randomProvider.apply(2001L), oceanFactory);
        }
        return IslandMixOceansLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)randomProvider.apply(100L), islandFactory, oceanFactory);
    }

    public static Layer build(long seed) {
        return new Layer(IslandLayerProvider.setup(salt -> new LazyAreaLayerContext(25, seed, salt)));
    }
}

