/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.islands.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.pixelatedw.islands.config.CommonConfig;
import xyz.pixelatedw.islands.config.WeightConfig;
import xyz.pixelatedw.islands.helpers.WeightedList;

public class IslandsHelper {
    private static WeightedList<Biome> islandBiomesList = new WeightedList();
    private static WeightedList<Biome> oceanBiomesList = new WeightedList();

    public static void createBiomeLists() {
        List<String> bannedIslandBiomes = CommonConfig.INSTANCE.getBannedIslandsBiomes();
        Predicate<Biome> isNotOceanPredicate = biome -> biome.func_201856_r() != Biome.Category.OCEAN;
        Predicate<Biome> islandsIgnorePredicate = biome -> !bannedIslandBiomes.contains(biome.getRegistryName().toString());
        for (Biome biome2 : new ArrayList(ForgeRegistries.BIOMES.getValues()).stream().filter(islandsIgnorePredicate).filter(isNotOceanPredicate).collect(Collectors.toList())) {
            double weight = WeightConfig.INSTANCE.getIslandBiomeWeight(biome2.getRegistryName());
            islandBiomesList.addEntry(biome2, weight);
        }
        List<String> bannedOceanBiomes = CommonConfig.INSTANCE.getBannedOceanBiomes();
        Predicate<Biome> isOceanPredicate = biome -> biome.func_201856_r() == Biome.Category.OCEAN;
        Predicate<Biome> oceanIgnorePredicate = biome -> !bannedOceanBiomes.contains(biome.getRegistryName().toString());
        for (Biome biome3 : new ArrayList(ForgeRegistries.BIOMES.getValues()).stream().filter(oceanIgnorePredicate).filter(isOceanPredicate).collect(Collectors.toList())) {
            double weight = WeightConfig.INSTANCE.getOceanBiomeWeight(biome3.getRegistryName());
            oceanBiomesList.addEntry(biome3, weight);
        }
    }

    public static boolean isOcean(int biomeId) {
        List oceansList = ForgeRegistries.BIOMES.getValues().stream().filter(b -> b.func_201856_r() == Biome.Category.OCEAN).collect(Collectors.toList());
        for (Biome biome : oceansList) {
            if (IslandsHelper.getBiomeId(biome) != biomeId) continue;
            return true;
        }
        return false;
    }

    public static Set<Biome> getBiomeSet() {
        HashSet<Biome> set = new HashSet<Biome>();
        ForgeRegistries.BIOMES.forEach(set::add);
        return set;
    }

    public static int getRandomIslandBiome(INoiseRandom rand) {
        if (islandBiomesList.size() == 0) {
            return IslandsHelper.getBiomeId(Biomes.field_76767_f);
        }
        Biome biome = islandBiomesList.getRandom(rand);
        return IslandsHelper.getBiomeId(biome);
    }

    public static int getRandomOceanBiome(INoiseRandom rand) {
        if (oceanBiomesList.size() == 0) {
            return IslandsHelper.getBiomeId(Biomes.field_150575_M);
        }
        Biome biome = oceanBiomesList.getRandom(rand);
        return IslandsHelper.getBiomeId(biome);
    }

    public static int getBiomeId(Biome biome) {
        return ((ForgeRegistry)ForgeRegistries.BIOMES).getID((IForgeRegistryEntry)biome);
    }

    public static Biome getBiome(int biomeId) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (IslandsHelper.getBiomeId(biome) != biomeId) continue;
            return biome;
        }
        return Biomes.field_150575_M;
    }
}

