/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.islands.layers;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.layer.traits.IAreaTransformer2;
import net.minecraft.world.gen.layer.traits.IDimOffset0Transformer;
import xyz.pixelatedw.islands.config.CommonConfig;
import xyz.pixelatedw.islands.helpers.BiomeHelper;
import xyz.pixelatedw.islands.helpers.IslandsHelper;

public enum IslandMixOceansLayer implements IAreaTransformer2,
IDimOffset0Transformer
{
    INSTANCE;


    public int func_215723_a(INoiseRandom random, IArea area1, IArea area2, int posX, int posZ) {
        int i = area1.func_202678_a(this.func_215721_a(posX), this.func_215722_b(posZ));
        int j = area2.func_202678_a(this.func_215721_a(posX), this.func_215722_b(posZ));
        if (!IslandsHelper.isOcean(i)) {
            return i;
        }
        Biome oceanBiome = IslandsHelper.getBiome(j);
        if (this.isOceanBanned(oceanBiome.getRegistryName())) {
            return i;
        }
        for (int i1 = -8; i1 <= 8; i1 += 4) {
            for (int j1 = -8; j1 <= 8; j1 += 4) {
                int k1 = area1.func_202678_a(this.func_215721_a(posX + i1), this.func_215722_b(posZ + j1));
                if (IslandsHelper.isOcean(k1)) continue;
                if (j == BiomeHelper.WARM_OCEAN && !this.isOceanBanned(Biomes.field_203615_U)) {
                    return BiomeHelper.LUKEWARM_OCEAN;
                }
                if (j != BiomeHelper.FROZEN_OCEAN || this.isOceanBanned(Biomes.field_203616_V)) continue;
                return BiomeHelper.COLD_OCEAN;
            }
        }
        if (i == BiomeHelper.DEEP_OCEAN) {
            if (j == BiomeHelper.LUKEWARM_OCEAN && !this.isOceanBanned(Biomes.field_203618_X)) {
                return BiomeHelper.DEEP_LUKEWARM_OCEAN;
            }
            if (j == BiomeHelper.OCEAN && !this.isOceanBanned(Biomes.field_150575_M)) {
                return BiomeHelper.DEEP_OCEAN;
            }
            if (j == BiomeHelper.COLD_OCEAN && !this.isOceanBanned(Biomes.field_203619_Y)) {
                return BiomeHelper.DEEP_COLD_OCEAN;
            }
            if (j == BiomeHelper.FROZEN_OCEAN && !this.isOceanBanned(Biomes.field_203620_Z)) {
                return BiomeHelper.DEEP_FROZEN_OCEAN;
            }
        }
        return j;
    }

    private boolean isOceanBanned(Biome registryKey) {
        return this.isOceanBanned(registryKey.getRegistryName());
    }

    private boolean isOceanBanned(ResourceLocation key) {
        return CommonConfig.INSTANCE.getBannedOceanBiomes().contains(key.toString());
    }
}

