/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.islands.layers;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;
import xyz.pixelatedw.islands.config.CommonConfig;
import xyz.pixelatedw.islands.helpers.BiomeHelper;
import xyz.pixelatedw.islands.helpers.IslandsHelper;

public enum IslandShoreLayer implements ICastleTransformer
{
    INSTANCE;


    public int func_202748_a(INoiseRandom context, int north, int west, int south, int east, int center) {
        Biome biome = IslandsHelper.getBiome(center);
        if (center == BiomeHelper.MUSHROOM_FIELDS) {
            if (this.isShallowOcean(north) || this.isShallowOcean(west) || this.isShallowOcean(south) || this.isShallowOcean(east)) {
                if (!this.isShoreBanned(Biomes.field_76788_q)) {
                    return BiomeHelper.MUSHROOM_FIELD_SHORE;
                }
                return center;
            }
        } else if (biome != null && biome.func_201856_r() == Biome.Category.JUNGLE) {
            if (!(this.isJungleCompatible(north) && this.isJungleCompatible(west) && this.isJungleCompatible(south) && this.isJungleCompatible(east))) {
                if (!this.isShoreBanned(Biomes.field_150574_L)) {
                    return BiomeHelper.JUNGLE_EDGE;
                }
                return center;
            }
            if (this.isOcean(north) || this.isOcean(west) || this.isOcean(south) || this.isOcean(east)) {
                if (!this.isShoreBanned(Biomes.field_76787_r)) {
                    return BiomeHelper.BEACH;
                }
                return center;
            }
        } else if (center != BiomeHelper.MOUNTAINS && center != BiomeHelper.WOODED_MOUNTAINS && center != BiomeHelper.MOUNTAIN_EDGE) {
            if (biome != null && biome.func_201851_b() == Biome.RainType.SNOW) {
                if (!this.isOcean(center) && (this.isOcean(north) || this.isOcean(west) || this.isOcean(south) || this.isOcean(east))) {
                    if (!this.isShoreBanned(Biomes.field_150577_O)) {
                        return BiomeHelper.SNOWY_BEACH;
                    }
                    return center;
                }
            } else if (center != BiomeHelper.BADLANDS && center != BiomeHelper.WOODED_BADLANDS_PLATEAU) {
                if (!this.isOcean(center) && center != BiomeHelper.RIVER && center != BiomeHelper.SWAMP && (this.isOcean(north) || this.isOcean(west) || this.isOcean(south) || this.isOcean(east))) {
                    if (!this.isShoreBanned(Biomes.field_76787_r)) {
                        return BiomeHelper.BEACH;
                    }
                    return center;
                }
            } else if (!(this.isOcean(north) || this.isOcean(west) || this.isOcean(south) || this.isOcean(east) || this.isMesa(north) && this.isMesa(west) && this.isMesa(south) && this.isMesa(east))) {
                if (!this.isShoreBanned(Biomes.field_76769_d)) {
                    return BiomeHelper.DESERT;
                }
                return center;
            }
        } else if (!this.isOcean(center) && (this.isOcean(north) || this.isOcean(west) || this.isOcean(south) || this.isOcean(east))) {
            if (!this.isShoreBanned(Biomes.field_150576_N)) {
                return BiomeHelper.STONE_SHORE;
            }
            return center;
        }
        return center;
    }

    private boolean isJungleCompatible(int biomeId) {
        if (IslandsHelper.getBiome(biomeId) != null && IslandsHelper.getBiome(biomeId).func_201856_r() == Biome.Category.JUNGLE) {
            return true;
        }
        return biomeId == BiomeHelper.JUNGLE_EDGE || biomeId == BiomeHelper.JUNGLE || biomeId == BiomeHelper.JUNGLE_HILLS || biomeId == BiomeHelper.FOREST || biomeId == BiomeHelper.TAIGA || this.isOcean(biomeId);
    }

    private boolean isMesa(int biomeId) {
        return biomeId == BiomeHelper.BADLANDS || biomeId == BiomeHelper.WOODED_BADLANDS_PLATEAU || biomeId == BiomeHelper.BADLANDS_PLATEAU || biomeId == BiomeHelper.ERODED_BADLANDS || biomeId == BiomeHelper.MODIFIED_WOODED_BADLANDS_PLATEAU || biomeId == BiomeHelper.MODIFIED_BADLANDS_PLATEAU;
    }

    private boolean isOcean(int biomeIn) {
        return biomeIn == BiomeHelper.WARM_OCEAN || biomeIn == BiomeHelper.LUKEWARM_OCEAN || biomeIn == BiomeHelper.OCEAN || biomeIn == BiomeHelper.COLD_OCEAN || biomeIn == BiomeHelper.FROZEN_OCEAN || biomeIn == BiomeHelper.DEEP_WARM_OCEAN || biomeIn == BiomeHelper.DEEP_LUKEWARM_OCEAN || biomeIn == BiomeHelper.DEEP_OCEAN || biomeIn == BiomeHelper.DEEP_COLD_OCEAN || biomeIn == BiomeHelper.DEEP_FROZEN_OCEAN;
    }

    private boolean isShallowOcean(int biomeIn) {
        return biomeIn == BiomeHelper.WARM_OCEAN || biomeIn == BiomeHelper.LUKEWARM_OCEAN || biomeIn == BiomeHelper.OCEAN || biomeIn == BiomeHelper.COLD_OCEAN || biomeIn == BiomeHelper.FROZEN_OCEAN;
    }

    private boolean isShoreBanned(Biome registryKey) {
        return CommonConfig.INSTANCE.getBannedIslandsBiomes().contains(registryKey.getRegistryName().toString());
    }
}

