/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;

public class IngredientInfoRecipe<T> {
    private static final int lineSpacing = 2;
    private final List<String> description;
    private final List<T> ingredients;
    private final IIngredientType<T> ingredientType;

    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, String ... descriptionKeys) {
        ArrayList<IngredientInfoRecipe<T>> recipes = new ArrayList<IngredientInfoRecipe<T>>();
        List<String> descriptionLines = IngredientInfoRecipe.translateDescriptionLines(descriptionKeys);
        descriptionLines = IngredientInfoRecipe.expandNewlines(descriptionLines);
        descriptionLines = IngredientInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.getClass();
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<String> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe<T> recipe = new IngredientInfoRecipe<T>(ingredients, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static List<String> translateDescriptionLines(String ... descriptionKeys) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        for (String descriptionKey : descriptionKeys) {
            String translatedLine = Translator.translateToLocal(descriptionKey);
            descriptionLines.add(translatedLine);
        }
        return descriptionLines;
    }

    private static List<String> expandNewlines(List<String> descriptionLines) {
        ArrayList<String> descriptionLinesExpanded = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            String[] descriptionLineExpanded = descriptionLine.split("\\\\n");
            Collections.addAll(descriptionLinesExpanded, descriptionLineExpanded);
        }
        return descriptionLinesExpanded;
    }

    private static List<String> wrapDescriptionLines(List<String> descriptionLines) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ArrayList<String> descriptionLinesWrapped = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            List textLines = minecraft.field_71466_p.func_78271_c(descriptionLine, 160);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private IngredientInfoRecipe(List<T> ingredients, IIngredientType<T> ingredientType, List<String> description) {
        this.description = description;
        this.ingredients = ingredients;
        this.ingredientType = ingredientType;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public IIngredientType<T> getIngredientType() {
        return this.ingredientType;
    }

    public List<T> getIngredients() {
        return this.ingredients;
    }
}

