/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class BlastFurnaceRecipe
extends IESerializableRecipe {
    public static RecipeType<BlastFurnaceRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<BlastFurnaceRecipe>> SERIALIZER;
    public static final CachedRecipeList<BlastFurnaceRecipe> RECIPES;
    public final IngredientWithSize input;
    public final Lazy<ItemStack> output;
    @Nonnull
    public final Lazy<ItemStack> slag;
    public final int time;

    public BlastFurnaceRecipe(ResourceLocation id, Lazy<ItemStack> output, IngredientWithSize input, int time, @Nonnull Lazy<ItemStack> slag) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.time = time;
        this.slag = slag;
    }

    protected IERecipeSerializer<BlastFurnaceRecipe> getIESerializer() {
        return (IERecipeSerializer)((Object)SERIALIZER.get());
    }

    public ItemStack m_8043_() {
        return (ItemStack)this.output.get();
    }

    public boolean matches(ItemStack input) {
        return this.input.test(input);
    }

    public static BlastFurnaceRecipe findRecipe(Level level, ItemStack input, @Nullable BlastFurnaceRecipe hint) {
        if (input.m_41619_()) {
            return null;
        }
        if (hint != null && hint.matches(input)) {
            return hint;
        }
        for (BlastFurnaceRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    static {
        RECIPES = new CachedRecipeList<BlastFurnaceRecipe>(() -> TYPE, BlastFurnaceRecipe.class);
    }
}

