/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class ClocheFertilizer
extends IESerializableRecipe {
    public static RecipeType<ClocheFertilizer> TYPE;
    public static RegistryObject<IERecipeSerializer<ClocheFertilizer>> SERIALIZER;
    public static final CachedRecipeList<ClocheFertilizer> RECIPES;
    public final Ingredient input;
    public final float growthModifier;

    public ClocheFertilizer(ResourceLocation id, Ingredient input, float growthModifier) {
        super((Lazy<ItemStack>)LAZY_EMPTY, TYPE, id);
        this.input = input;
        this.growthModifier = growthModifier;
    }

    public float getGrowthModifier() {
        return this.growthModifier;
    }

    protected IERecipeSerializer<ClocheFertilizer> getIESerializer() {
        return (IERecipeSerializer)((Object)SERIALIZER.get());
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public static float getFertilizerGrowthModifier(Level level, ItemStack stack) {
        for (ClocheFertilizer e : RECIPES.getRecipes(level)) {
            if (!e.input.test(stack)) continue;
            return e.getGrowthModifier();
        }
        return 0.0f;
    }

    public static boolean isValidFertilizer(Level level, ItemStack stack) {
        return ClocheFertilizer.getFertilizerGrowthModifier(level, stack) > 0.0f;
    }

    static {
        RECIPES = new CachedRecipeList<ClocheFertilizer>(() -> TYPE, ClocheFertilizer.class);
    }
}

