/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BulletHandler {
    public static final SetRestrictedField<Function<IBullet, Item>> GET_BULLET_ITEM = SetRestrictedField.common();
    public static ItemLike emptyCasing = Items.f_41852_;
    public static ItemLike emptyShell = Items.f_41852_;
    private static final BiMap<ResourceLocation, IBullet> REGISTRY = HashBiMap.create();

    public static void registerBullet(ResourceLocation name, IBullet bullet) {
        Preconditions.checkState((!REGISTRY.containsKey((Object)name) ? 1 : 0) != 0, (Object)(name + " is already registered"));
        Preconditions.checkState((!REGISTRY.containsValue((Object)bullet) ? 1 : 0) != 0);
        REGISTRY.put((Object)name, (Object)bullet);
    }

    public static IBullet getBullet(ResourceLocation name) {
        return (IBullet)REGISTRY.get((Object)name);
    }

    public static ResourceLocation findRegistryName(IBullet bullet) {
        if (bullet != null) {
            return (ResourceLocation)REGISTRY.inverse().get((Object)bullet);
        }
        return null;
    }

    public static ItemStack getBulletStack(ResourceLocation key) {
        return new ItemStack((ItemLike)BulletHandler.getBulletItem(key));
    }

    public static Item getBulletItem(ResourceLocation key) {
        return GET_BULLET_ITEM.getValue().apply(BulletHandler.getBullet(key));
    }

    public static Collection<ResourceLocation> getAllKeys() {
        return REGISTRY.keySet();
    }

    public static Collection<IBullet> getAllValues() {
        return REGISTRY.values();
    }

    public static interface IBullet {
        default public boolean isProperCartridge() {
            return true;
        }

        default public String getTranslationKey(ItemStack cartridge, String baseName) {
            return baseName;
        }

        default public void addTooltip(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        }

        default public int getProjectileCount(@Nullable Player shooter) {
            return 1;
        }

        default public Entity getProjectile(@Nullable Player shooter, ItemStack cartridge, Entity projectile, boolean charged) {
            return projectile;
        }

        public void onHitTarget(Level var1, HitResult var2, @Nullable UUID var3, Entity var4, boolean var5);

        public ItemStack getCasing(ItemStack var1);

        public ResourceLocation[] getTextures();

        public int getColour(ItemStack var1, int var2);

        default public boolean isValidForTurret() {
            return false;
        }

        default public SoundEvent getSound() {
            return null;
        }
    }

    public static class DamagingBullet
    implements IBullet {
        final DamageSourceProvider damageSourceGetter;
        final DoubleSupplier damage;
        boolean resetHurt = false;
        boolean setFire = false;
        Supplier<ItemStack> casing;
        ResourceLocation[] textures;

        public DamagingBullet(DamageSourceProvider damageSourceGetter, float damage, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this(damageSourceGetter, damage, false, false, casing, textures);
        }

        public DamagingBullet(DamageSourceProvider damageSourceGetter, DoubleSupplier damage, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this(damageSourceGetter, damage, false, false, casing, textures);
        }

        public DamagingBullet(DamageSourceProvider damageSourceGetter, float damage, boolean resetHurt, boolean setFire, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this(damageSourceGetter, () -> damage, resetHurt, setFire, casing, textures);
        }

        public DamagingBullet(DamageSourceProvider damageSourceGetter, DoubleSupplier damage, boolean resetHurt, boolean setFire, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this.damageSourceGetter = damageSourceGetter;
            this.damage = damage;
            this.resetHurt = resetHurt;
            this.setFire = setFire;
            this.casing = casing;
            this.textures = textures;
        }

        protected float getDamage(Entity hitEntity, boolean headshot) {
            return (float)(this.damage.getAsDouble() * (double)(headshot ? 1.5f : 1.0f));
        }

        @Override
        public void onHitTarget(Level world, HitResult rtr, @Nullable UUID shooterUUID, Entity projectile, boolean headshot) {
            if (!(rtr instanceof EntityHitResult)) {
                return;
            }
            EntityHitResult target = (EntityHitResult)rtr;
            Entity hitEntity = target.m_82443_();
            if (!world.f_46443_ && hitEntity != null && this.damageSourceGetter != null) {
                Player shooter = null;
                if (shooterUUID != null) {
                    shooter = world.m_46003_(shooterUUID);
                }
                if (hitEntity.m_6469_(this.damageSourceGetter.getSource(projectile, (Entity)shooter, hitEntity), this.getDamage(hitEntity, headshot))) {
                    if (this.resetHurt) {
                        hitEntity.f_19802_ = 0;
                    }
                    if (this.setFire) {
                        hitEntity.m_20254_(3);
                    }
                }
            }
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return (ItemStack)this.casing.get();
        }

        @Override
        public ResourceLocation[] getTextures() {
            return this.textures;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }

        public static interface DamageSourceProvider {
            public DamageSource getSource(Entity var1, Entity var2, Entity var3);
        }
    }
}

