/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class WireCollisionData {
    private final Map<BlockPos, List<CollisionInfo>> blockToWires = new Object2ObjectOpenHashMap();
    private final Map<SectionPos, List<ConnectionSegments>> sectionsToWires = new Object2ObjectOpenHashMap();
    private final GlobalWireNetwork net;
    private final boolean isClient;

    WireCollisionData(GlobalWireNetwork net, boolean isClient) {
        this.net = net;
        this.isClient = isClient;
    }

    public void addConnection(Connection conn) {
        if (conn.isInternal() || conn.blockDataGenerated) {
            return;
        }
        WireLogger.logger.info("Adding block data for {}", (Object)conn);
        if (this.isClient) {
            this.forEachSection(conn, (sectionPos, segments) -> {
                Map<SectionPos, List<ConnectionSegments>> map = this.sectionsToWires;
                synchronized (map) {
                    this.sectionsToWires.computeIfAbsent((SectionPos)sectionPos, $ -> new ArrayList()).add(segments);
                }
            });
        } else {
            Preconditions.checkState((this.net.getLocalNet(conn.getEndA()) == this.net.getLocalNet(conn.getEndB()) ? 1 : 0) != 0);
            WireUtils.raytraceAlongCatenary(conn, p -> this.add(p.block(), new CollisionInfo(p.entersAt(), p.leavesAt(), conn, true)), p -> this.add(p.block(), new CollisionInfo(p.entersAt(), p.leavesAt(), conn, false)));
        }
        conn.blockDataGenerated = true;
    }

    public void removeConnection(Connection conn) {
        WireLogger.logger.info("Removing block data for {}", (Object)conn);
        if (this.isClient) {
            this.forEachSection(conn, (sectionPos, segments) -> {
                Map<SectionPos, List<ConnectionSegments>> map = this.sectionsToWires;
                synchronized (map) {
                    List<ConnectionSegments> forSection = this.sectionsToWires.get(sectionPos);
                    if (forSection != null) {
                        forSection.remove(segments);
                        if (forSection.isEmpty()) {
                            this.sectionsToWires.remove(sectionPos);
                        }
                    }
                }
            });
        } else {
            WireUtils.raytraceAlongCatenary(conn, p -> this.remove(p.block(), conn), p -> this.remove(p.block(), conn));
        }
        conn.blockDataGenerated = false;
    }

    private void forEachSection(Connection conn, BiConsumer<SectionPos, ConnectionSegments> out) {
        MutableObject currentSection = new MutableObject(null);
        MutableInt sectionStart = new MutableInt(0);
        WireUtils.forEachRenderPoint(conn, (arg_0, arg_1, arg_2) -> WireCollisionData.lambda$forEachSection$7((Mutable)currentSection, out, conn, sectionStart, arg_0, arg_1, arg_2));
    }

    private void remove(BlockPos pos, Connection toRemove) {
        List<CollisionInfo> existing = this.blockToWires.get(pos);
        if (existing != null) {
            existing.removeIf(i -> i.connection == toRemove);
            if (existing.isEmpty()) {
                this.blockToWires.remove(pos);
            }
        }
    }

    private void add(BlockPos pos, CollisionInfo info) {
        List existing = this.blockToWires.computeIfAbsent(pos, $ -> new ArrayList());
        if (!existing.contains(info)) {
            existing.add(info);
        }
    }

    @Nonnull
    public Collection<CollisionInfo> getCollisionInfo(BlockPos pos) {
        ImmutableList ret = this.blockToWires.get(pos);
        if (ret == null) {
            ret = ImmutableList.of();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<ConnectionSegments> getWiresIn(SectionPos section) {
        Map<SectionPos, List<ConnectionSegments>> map = this.sectionsToWires;
        synchronized (map) {
            List<ConnectionSegments> containedWires = this.sectionsToWires.get(section);
            if (containedWires == null) {
                return null;
            }
            return List.copyOf(containedWires);
        }
    }

    private static /* synthetic */ void lambda$forEachSection$7(Mutable currentSection, BiConsumer out, Connection conn, MutableInt sectionStart, int id, Vec3 relative, SectionPos section) {
        if (!(currentSection.getValue() == null || section.equals(currentSection.getValue()) && id != 16)) {
            out.accept((SectionPos)currentSection.getValue(), new ConnectionSegments(conn, sectionStart.intValue(), id));
            currentSection.setValue(null);
        }
        if (currentSection.getValue() == null) {
            currentSection.setValue((Object)section);
            sectionStart.setValue(id);
        }
    }

    public record CollisionInfo(@Nonnull Vec3 intersectA, @Nonnull Vec3 intersectB, @Nonnull Connection connection, boolean isInBlock) {
        public LocalWireNetwork getLocalNet(GlobalWireNetwork net) {
            return this.connection.getContainingNet(net);
        }
    }

    public record ConnectionSegments(Connection connection, int firstPointToRender, int lastPointToRender) {
    }
}

