/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonLogicCircuitRegister;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.client.gui.elements.GuiSelectingList;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.gui.info.TooltipArea;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableBlockEntity;
import blusunrize.immersiveengineering.common.gui.CircuitTableContainer;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import blusunrize.immersiveengineering.common.network.MessageContainerUpdate;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;

public class CircuitTableScreen
extends IEContainerScreen<CircuitTableContainer> {
    private static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("circuit_table");
    private final CircuitTableBlockEntity tile;
    private GuiSelectingList operatorList;
    private final List<GuiButtonState<LogicCircuitHandler.LogicCircuitRegister>> inputButtons = new ArrayList<GuiButtonState<LogicCircuitHandler.LogicCircuitRegister>>(LogicCircuitHandler.LogicCircuitOperator.TOTAL_MAX_INPUTS);
    private GuiButtonState<LogicCircuitHandler.LogicCircuitRegister> outputButton;
    private final Rect2i copyArea;
    private final ResettableLazy<Optional<LogicCircuitHandler.LogicCircuitInstruction>> instruction = new ResettableLazy(() -> {
        LogicCircuitHandler.LogicCircuitOperator operator = this.getSelectedOperator();
        if (operator == null) {
            return Optional.empty();
        }
        LogicCircuitHandler.LogicCircuitRegister[] inputs = (LogicCircuitHandler.LogicCircuitRegister[])this.inputButtons.stream().map(GuiButtonState::getState).filter(Objects::nonNull).limit(operator.getArgumentCount()).toArray(LogicCircuitHandler.LogicCircuitRegister[]::new);
        if (inputs.length < operator.getArgumentCount()) {
            return Optional.empty();
        }
        return Optional.of(new LogicCircuitHandler.LogicCircuitInstruction(operator, this.outputButton.getState(), inputs));
    });

    public CircuitTableScreen(CircuitTableContainer container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.tile = (CircuitTableBlockEntity)container.tile;
        this.f_97726_ = 234;
        this.f_97727_ = 182;
        this.copyArea = new Rect2i(52, 7, 48, 63);
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)((Object)new EnergyInfoArea(this.f_97735_ + 217, this.f_97736_ + 16, this.tile.energyStorage)), (Object)((Object)new TooltipArea(this.copyArea, l -> {
            if (((CircuitTableContainer)this.f_97732_).m_142621_().m_41720_() instanceof LogicCircuitBoardItem) {
                l.add(TextUtils.applyFormat((Component)new TranslatableComponent("desc.immersiveengineering.info.circuit_table.copy"), ChatFormatting.GRAY));
            }
        })));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        ClientUtils.mc().f_91068_.m_90926_(true);
        this.operatorList = (GuiSelectingList)this.m_142416_((GuiEventListener)new GuiSelectingList((Screen)this, this.f_97735_ + 58, this.f_97736_ + 16, 36, 56, btn -> {
            this.f_96541_.m_6937_(this::updateButtons);
            this.f_96541_.m_6937_(this::updateInstruction);
        }, (String[])Arrays.stream(LogicCircuitHandler.LogicCircuitOperator.values()).map(Enum::name).toArray(String[]::new)).setPadding(1, 1, 2, 0));
        this.outputButton = (GuiButtonState)this.m_142416_((GuiEventListener)new GuiButtonLogicCircuitRegister(this.f_97735_ + 121, this.f_97736_ + 56, (Component)new TextComponent("Output"), btn -> this.f_96541_.m_6937_(this::updateInstruction)));
        this.updateButtons();
    }

    private LogicCircuitHandler.LogicCircuitInstruction getEditInstruction() {
        return LogicCircuitBoardItem.getInstruction(((Slot)((CircuitTableContainer)this.f_97732_).f_38839_.get(CircuitTableBlockEntity.getEditSlot())).m_7993_());
    }

    @Nullable
    private LogicCircuitHandler.LogicCircuitOperator getSelectedOperator() {
        LogicCircuitHandler.LogicCircuitInstruction editInstr = this.getEditInstruction();
        if (editInstr != null) {
            return editInstr.getOperator();
        }
        return LogicCircuitHandler.LogicCircuitOperator.getByString(this.operatorList.getSelectedString());
    }

    private void updateInstruction() {
        this.instruction.reset();
        this.instruction.get().ifPresentOrElse(instr -> {
            ((CircuitTableContainer)this.f_97732_).instruction = instr;
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageContainerUpdate(((CircuitTableContainer)this.f_97732_).f_38840_, instr.serialize()));
        }, () -> {
            ((CircuitTableContainer)this.f_97732_).instruction = null;
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageContainerUpdate(((CircuitTableContainer)this.f_97732_).f_38840_, new CompoundTag()));
        });
    }

    protected void m_6597_(Slot pSlot, int pSlotId, int pMouseButton, ClickType pType) {
        boolean editCircuit = pSlotId == CircuitTableBlockEntity.getEditSlot() || pType == ClickType.QUICK_MOVE && pSlotId >= ((CircuitTableContainer)this.f_97732_).slotCount && pSlot != null && pSlot.m_7993_().m_150930_((Item)IEItems.Misc.LOGIC_CIRCUIT_BOARD.get());
        super.m_6597_(pSlot, pSlotId, pMouseButton, pType);
        if (editCircuit) {
            this.f_96541_.m_6937_(this::updateButtons);
            this.f_96541_.m_6937_(this::updateInstruction);
        }
    }

    private void updateButtons() {
        LogicCircuitHandler.LogicCircuitInstruction editInstr;
        LogicCircuitHandler.LogicCircuitOperator operator = this.getSelectedOperator();
        if (operator != null) {
            int inputCount = operator.getArgumentCount();
            int inputStart = 130 - (inputCount * 10 - 1);
            if (inputCount < this.inputButtons.size()) {
                Iterator<GuiButtonState<LogicCircuitHandler.LogicCircuitRegister>> it = this.inputButtons.iterator();
                int i = 0;
                while (it.hasNext()) {
                    GuiButtonState<LogicCircuitHandler.LogicCircuitRegister> btn2 = it.next();
                    btn2.f_93620_ = this.f_97735_ + inputStart + 20 * i;
                    if (++i <= inputCount) continue;
                    this.m_169411_((GuiEventListener)btn2);
                    it.remove();
                }
            } else {
                for (int i = 0; i < inputCount; ++i) {
                    if (i < this.inputButtons.size()) {
                        this.inputButtons.get((int)i).f_93620_ = this.f_97735_ + inputStart + 20 * i;
                        continue;
                    }
                    this.inputButtons.add((GuiButtonState)this.m_142416_((GuiEventListener)new GuiButtonLogicCircuitRegister(this.f_97735_ + inputStart + 20 * i, this.f_97736_ + 18, (Component)new TextComponent("Input " + (i + 1)), btn -> this.f_96541_.m_6937_(this::updateInstruction))));
                }
            }
        }
        if ((editInstr = this.getEditInstruction()) != null) {
            this.operatorList.f_93623_ = false;
            this.operatorList.setSelectedString(editInstr.getOperator().name());
            for (int i = 0; i < editInstr.getInputs().length; ++i) {
                this.inputButtons.get(i).setStateByInt(editInstr.getInputs()[i].ordinal());
            }
            this.outputButton.setStateByInt(editInstr.getOutput().ordinal());
        } else {
            this.operatorList.f_93623_ = true;
        }
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        if (this.f_97734_ != null && !this.f_97734_.m_6657_()) {
            if (this.f_97734_.f_40219_ < CircuitTableBlockEntity.getEditSlot()) {
                int slotNum = this.f_97734_.f_40219_;
                addGray.accept((Component)new TranslatableComponent("desc.immersiveengineering.info.circuit_table.slot." + CircuitTableBlockEntity.SLOT_TYPES[slotNum]));
            } else if (this.f_97734_.f_40219_ == CircuitTableBlockEntity.getEditSlot()) {
                addGray.accept((Component)new TranslatableComponent("desc.immersiveengineering.info.circuit_table.slot.edit"));
            }
        }
    }

    @Override
    protected void m_7027_(PoseStack transform, int mouseX, int mouseY) {
        CircuitTableScreen.m_93208_((PoseStack)transform, (Font)this.f_96547_, (String)"Operator:", (int)76, (int)4, (int)DyeColor.LIGHT_GRAY.m_41071_());
        CircuitTableScreen.m_93208_((PoseStack)transform, (Font)this.f_96547_, (String)"Inputs:", (int)130, (int)8, (int)DyeColor.LIGHT_GRAY.m_41071_());
        CircuitTableScreen.m_93208_((PoseStack)transform, (Font)this.f_96547_, (String)"Outputs:", (int)130, (int)42, (int)DyeColor.LIGHT_GRAY.m_41071_());
        for (int i = 0; i < CircuitTableBlockEntity.SLOT_TYPES.length; ++i) {
            int amount = 0;
            DyeColor col = DyeColor.LIGHT_GRAY;
            if (this.instruction.get().isPresent() && this.getEditInstruction() == null) {
                amount = CircuitTableBlockEntity.getIngredientAmount(this.instruction.get().get(), i);
                col = ((Slot)((CircuitTableContainer)this.f_97732_).f_38839_.get(i)).m_7993_().m_41613_() >= amount ? DyeColor.GREEN : DyeColor.RED;
            }
            this.f_96547_.m_92883_(transform, "x " + amount, 30.0f, (float)(18 + 20 * i), col.m_41071_());
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        for (GuiButtonState<LogicCircuitHandler.LogicCircuitRegister> input : this.inputButtons) {
            if (!input.m_198029_()) continue;
            return input.m_5534_(codePoint, modifiers);
        }
        if (this.outputButton.m_198029_()) {
            return this.outputButton.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        LogicCircuitHandler.LogicCircuitInstruction instr;
        if (this.isMouseIn((int)mouseX, (int)mouseY, 52, 7, 100, 70) && ((CircuitTableContainer)this.f_97732_).m_142621_().m_41720_() instanceof LogicCircuitBoardItem && (instr = LogicCircuitBoardItem.getInstruction(((CircuitTableContainer)this.f_97732_).m_142621_())) != null) {
            this.operatorList.setSelectedString(instr.getOperator().name());
            this.updateButtons();
            this.outputButton.setStateByInt(instr.getOutput().ordinal());
            LogicCircuitHandler.LogicCircuitRegister[] inputs = instr.getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                this.inputButtons.get(i).setStateByInt(inputs[i].ordinal());
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

