/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.phys.Vec3;

public enum PlacementLimitation {
    SIDE_CLICKED((side, placer, hitPos) -> side),
    PISTON_LIKE((side, placer, hitPos) -> Direction.m_122382_((Entity)placer)[0]),
    HORIZONTAL((side, placer, hitPos) -> Direction.m_122364_((double)placer.m_146908_())),
    VERTICAL((side, placer, hitPos) -> side != Direction.DOWN && (side == Direction.UP || hitPos.f_82480_ <= 0.5) ? Direction.UP : Direction.DOWN),
    HORIZONTAL_AXIS((side, placer, hitPos) -> {
        Direction f = Direction.m_122364_((double)placer.m_146908_());
        if (f == Direction.SOUTH || f == Direction.WEST) {
            return f.m_122424_();
        }
        return f;
    }),
    HORIZONTAL_QUADRANT((side, placer, hitPos) -> {
        if (side.m_122434_() != Direction.Axis.Y) {
            return side.m_122424_();
        }
        double xFromMid = hitPos.f_82479_ - 0.5;
        double zFromMid = hitPos.f_82481_ - 0.5;
        double max = Math.max(Math.abs(xFromMid), Math.abs(zFromMid));
        if (max == Math.abs(xFromMid)) {
            return xFromMid < 0.0 ? Direction.WEST : Direction.EAST;
        }
        return zFromMid < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }),
    HORIZONTAL_PREFER_SIDE((side, placer, hitPos) -> side.m_122434_() != Direction.Axis.Y ? side.m_122424_() : placer.m_6350_()),
    FIXED_DOWN((side, placer, hitPos) -> Direction.DOWN);

    private final DirectionGetter dirGetter;

    private PlacementLimitation(DirectionGetter dirGetter) {
        this.dirGetter = dirGetter;
    }

    public Direction getDirectionForPlacement(Direction side, LivingEntity placer, Vec3 clickLocation) {
        return this.dirGetter.getDirectionForPlacement(side, placer, clickLocation);
    }

    public Direction getDirectionForPlacement(BlockPlaceContext context) {
        Vec3 clickLocation = context.m_43720_();
        BlockPos pos = context.m_8083_();
        clickLocation = clickLocation.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return this.getDirectionForPlacement(context.m_43719_(), (LivingEntity)context.m_43723_(), clickLocation);
    }

    private static interface DirectionGetter {
        public Direction getDirectionForPlacement(Direction var1, LivingEntity var2, Vec3 var3);
    }
}

