/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DieselGeneratorBlockEntity
extends MultiblockPartBlockEntity<DieselGeneratorBlockEntity>
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ISoundBE,
IEClientTickableBE {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public boolean active = false;
    public float animation_fanRotationStep = 0.0f;
    public float animation_fanRotation = 0.0f;
    public int animation_fanFadeIn = 0;
    public int animation_fanFadeOut = 0;
    private final List<CapabilityReference<IEnergyStorage>> outputs = Arrays.asList(CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(0, 1, 4)).m_142082_(0, 1, 0), Direction.DOWN), CapabilityEnergy.ENERGY), CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(1, 1, 4)).m_142082_(0, 1, 0), Direction.DOWN), CapabilityEnergy.ENERGY), CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(2, 1, 4)).m_142082_(0, 1, 0), Direction.DOWN), CapabilityEnergy.ENERGY));
    private final BiFunction<Level, Fluid, GeneratorFuel> recipeGetter = CachedRecipe.cached(GeneratorFuel::getRecipeFor);
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(DieselGeneratorBlockEntity::getShape);
    private final MultiblockCapability<IFluidHandler> fluidCap = MultiblockCapability.make(this, be -> be.fluidCap, MultiblockPartBlockEntity::master, this.registerFluidInput((IFluidTank[])this.tanks));

    public DieselGeneratorBlockEntity(BlockEntityType<DieselGeneratorBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.DIESEL_GENERATOR, type, true, pos, state);
        this.tanks[0].setValidator(fs -> this.recipeGetter.apply(this.f_58857_, fs.getFluid()) != null);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.m_128469_("tank0"));
        this.active = nbt.m_128471_("active");
        this.animation_fanRotation = nbt.m_128457_("animation_fanRotation");
        this.animation_fanFadeIn = nbt.m_128451_("animation_fanFadeIn");
        this.animation_fanFadeOut = nbt.m_128451_("animation_fanFadeOut");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128365_("tank0", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
        nbt.m_128379_("active", this.active);
        nbt.m_128350_("animation_fanRotation", this.animation_fanRotation);
        nbt.m_128405_("animation_fanFadeIn", this.animation_fanFadeIn);
        nbt.m_128405_("animation_fanFadeOut", this.animation_fanFadeOut);
    }

    public void tickCommon() {
        if (this.active || this.animation_fanFadeIn > 0 || this.animation_fanFadeOut > 0) {
            float step;
            float base = 18.0f;
            float f = step = this.active ? base : 0.0f;
            if (this.animation_fanFadeIn > 0) {
                step -= (float)this.animation_fanFadeIn / 80.0f * base;
                --this.animation_fanFadeIn;
            }
            if (this.animation_fanFadeOut > 0) {
                step += (float)this.animation_fanFadeOut / 80.0f * base;
                --this.animation_fanFadeOut;
            }
            this.animation_fanRotationStep = step;
            this.animation_fanRotation += step;
            this.animation_fanRotation %= 360.0f;
        }
    }

    @Override
    public void tickClient() {
        this.tickCommon();
        ImmersiveEngineering.proxy.handleTileSound(IESounds.dieselGenerator, this, this.active, 0.5f, 1.0f);
        if (this.active && this.f_58857_.m_46467_() % 4L == 0L) {
            BlockPos exhaust = this.getBlockPosForPos(new BlockPos(2, 2, 2));
            Direction fl = this.getFacing();
            Direction fw = this.getFacing().m_122427_();
            if (this.getIsMirrored()) {
                fw = fw.m_122424_();
            }
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)exhaust.m_123341_() + 0.5 + (double)((float)fl.m_122429_() * 0.3125f) + (double)((float)(-fw.m_122429_()) * 0.3125f), (double)exhaust.m_123342_() + 1.25, (double)exhaust.m_123343_() + 0.5 + (double)((float)fl.m_122431_() * 0.3125f) + (double)((float)(-fw.m_122431_()) * 0.3125f), 0.015625 - 0.03125 * Math.random(), 0.0625, 0.015625 - 0.03125 * Math.random());
        }
    }

    @Override
    public void tickServer() {
        this.tickCommon();
        boolean prevActive = this.active;
        if (!this.isRSDisabled() && !this.tanks[0].getFluid().isEmpty()) {
            GeneratorFuel recipe = this.recipeGetter.apply(this.f_58857_, this.tanks[0].getFluid().getFluid());
            if (recipe != null) {
                int burnTime = recipe.getBurnTime();
                int fluidConsumed = 1000 / burnTime;
                int output = (Integer)IEServerConfig.MACHINES.dieselGen_output.get();
                List<IEnergyStorage> presentOutputs = this.outputs.stream().map(CapabilityReference::getNullable).filter(Objects::nonNull).collect(Collectors.toList());
                if (!presentOutputs.isEmpty() && this.tanks[0].getFluidAmount() >= fluidConsumed && EnergyHelper.distributeFlux(presentOutputs, output, false) < output) {
                    if (!this.active) {
                        this.active = true;
                        this.animation_fanFadeIn = 80;
                    }
                    this.tanks[0].drain(fluidConsumed, IFluidHandler.FluidAction.EXECUTE);
                } else if (this.active) {
                    this.active = false;
                    this.animation_fanFadeOut = 80;
                }
            }
        } else if (this.active) {
            this.active = false;
            this.animation_fanFadeOut = 80;
        }
        if (prevActive != this.active) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    public static AABB getBlockBounds(BlockPos posInMultiblock) {
        boolean lessThan21;
        if (new BlockPos(1, 0, 4).equals((Object)posInMultiblock)) {
            return new AABB(0.0, 0.5, -0.625, 1.0, 1.5, 1.0);
        }
        if (ImmutableSet.of((Object)new BlockPos(0, 0, 4), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(2, 2, 0)).contains((Object)posInMultiblock)) {
            return new AABB(0.0, 0.0, 0.0, 0.5, posInMultiblock.m_123342_() == 2 ? 0.8125 : 1.0, posInMultiblock.m_123343_() == 0 ? 1.125 : 1.0);
        }
        if (ImmutableSet.of((Object)new BlockPos(2, 0, 4), (Object)new BlockPos(0, 1, 0), (Object)new BlockPos(0, 2, 0)).contains((Object)posInMultiblock)) {
            return new AABB(0.5, 0.0, 0.0, 1.0, posInMultiblock.m_123342_() == 2 ? 0.8125 : 1.0, posInMultiblock.m_123343_() == 0 ? 1.125 : 1.0);
        }
        if (new BlockPos(1, 2, 0).equals((Object)posInMultiblock)) {
            return new AABB(0.0, 0.0, 0.0, 1.0, posInMultiblock.m_123342_() == 2 ? 0.8125 : 1.0, posInMultiblock.m_123343_() == 0 ? 0.625 : 1.0);
        }
        if (posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() == 4) {
            return new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        }
        if (posInMultiblock.m_123341_() == 1 && posInMultiblock.m_123342_() > 0 && posInMultiblock.m_123343_() == 3) {
            return new AABB(0.0625, 0.0, 0.0, 0.9375, posInMultiblock.m_123342_() == 2 ? 0.3125 : 1.0, 0.625);
        }
        if (new BoundingBox(1, 2, 1, 1, 2, 2).m_71051_((Vec3i)posInMultiblock)) {
            return new AABB(0.0625, 0.0, 0.0, 0.9375, 0.3125, 1.0);
        }
        if (posInMultiblock.m_123341_() % 2 == 0 && posInMultiblock.m_123342_() == 0) {
            return new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        }
        boolean bl = lessThan21 = posInMultiblock.m_123342_() == 0 || posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() > 2;
        if (posInMultiblock.m_123341_() == 0 && posInMultiblock.m_123342_() < 2) {
            return new AABB(0.9375, -0.5, 0.0, 1.0, 0.625, lessThan21 ? 0.625 : 1.0);
        }
        if (posInMultiblock.m_123341_() == 2 && posInMultiblock.m_123342_() < 2) {
            return new AABB(0.0, -0.5, 0.0, 0.0625, 0.625, lessThan21 ? 0.625 : 1.0);
        }
        if (posInMultiblock.m_123341_() % 2 == 0 && posInMultiblock.m_123342_() == 2 && posInMultiblock.m_123343_() == 2) {
            return Utils.flipBox(false, posInMultiblock.m_123341_() == 2, new AABB(0.5625, 0.0, -0.0625, 1.0625, posInMultiblock.m_123341_() == 2 ? 1.125 : 0.75, 0.4375));
        }
        return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        VoxelShape base = this.getShape(SHAPES);
        if (this.isRedstonePos() && ctx != null && !ctx.m_6513_(ScaffoldingBlock.CHECK_SHAPE, this.f_58858_, false)) {
            AABB box = CachedShapesWithTransform.withFacingAndMirror(new AABB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0), this.getFacing(), this.getIsMirrored());
            base = Shapes.m_83110_((VoxelShape)base, (VoxelShape)Shapes.m_83064_((AABB)box));
        }
        return base;
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(1, 1, 4).equals((Object)posInMultiblock)) {
            return Lists.newArrayList((Object[])new AABB[]{new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AABB(0.0, -0.5, -0.625, 1.0, 0.5, 1.0)});
        }
        if (posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() == 4) {
            return Utils.flipBoxes(false, posInMultiblock.m_123341_() == 2, new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AABB(0.125, 0.0, 0.125, 0.375, 0.5, 0.375), new AABB(0.125, 0.0, 0.625, 0.375, 0.5, 0.875));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)DieselGeneratorBlockEntity.getBlockBounds(posInMultiblock), (Object)new AABB(0.5, 0.25, 0.3125, 1.0, 0.75, 0.6875), (Object)new AABB(0.6875, -0.5, 0.4375, 0.8125, 0.25, 0.5625));
        }
        if (posInMultiblock.m_123341_() % 2 == 0 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123343_() < 4) {
            double offset;
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{DieselGeneratorBlockEntity.getBlockBounds(posInMultiblock)});
            if (posInMultiblock.m_123343_() > 2) {
                list.add(new AABB(0.125, 0.5625, 0.25, 1.0, 0.8125, 0.5));
                list.add(new AABB(0.125, 0.5625, 0.5, 0.375, 0.8125, 1.0));
            } else if (posInMultiblock.m_123343_() > 0) {
                offset = posInMultiblock.m_123343_() > 1 ? 0.0 : 1.0;
                list.add(new AABB(0.4375, 0.5, -0.5625 + offset, 1.0, 1.0, 0.75 + offset));
            }
            if (posInMultiblock.m_123343_() < 2) {
                offset = posInMultiblock.m_123343_() == 1 ? 0.0 : 1.0;
                list.add(new AABB(0.375, 0.5625, 0.5625 + offset, 0.4375, 0.8125, 0.8125 + offset));
                list.add(new AABB(0.375, 0.5625, -0.875 + offset, 0.5, 0.8125, -0.625 + offset));
                list.add(new AABB(0.125, 0.5625, -0.875 + offset, 0.375, 0.8125, 0.8125 + offset));
            }
            return Utils.flipBoxes(false, posInMultiblock.m_123341_() == 2, list);
        }
        return ImmutableList.of((Object)DieselGeneratorBlockEntity.getBlockBounds(posInMultiblock));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 2));
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || this.isFluidInput(facing))) {
            return this.fluidCap.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    private boolean isFluidInput(Direction side) {
        return this.posInMultiblock.m_123343_() == 4 && this.posInMultiblock.m_123342_() == 0 && this.posInMultiblock.m_123341_() % 2 == 0 && side.m_122434_() == this.getFacing().m_122428_().m_122434_();
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return this.active;
    }

    @Override
    public float getSoundRadiusSq() {
        return 1024.0f;
    }
}

