/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.PostTransformerBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PostTransformerBlock
extends ConnectorBlock<PostTransformerBlockEntity> {
    public PostTransformerBlock(BlockBehaviour.Properties props) {
        super(props, IEBlockEntities.POST_TRANSFORMER);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{IEProperties.FACING_HORIZONTAL, BlockStateProperties.f_61362_});
    }

    public Item m_5456_() {
        return IEBlocks.Connectors.TRANSFORMER.get().m_5456_();
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState baseState = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return this.stateForPos(baseState, currentPos, (BlockGetter)worldIn, Blocks.f_50016_.m_49966_());
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState baseState = super.m_5573_(context);
        return this.stateForPos(baseState, context.m_8083_(), (BlockGetter)context.m_43725_(), null);
    }

    private BlockState stateForPos(@Nullable BlockState baseState, BlockPos pos, BlockGetter world, BlockState empty) {
        if (baseState == null || baseState.m_60734_() != this) {
            return empty;
        }
        Direction preferred = (Direction)baseState.m_61143_((Property)IEProperties.FACING_HORIZONTAL);
        Optional<Direction> newFacing = PostTransformerBlock.findAttacheablePost(pos, world, preferred);
        if (newFacing.isPresent()) {
            return (BlockState)baseState.m_61124_((Property)IEProperties.FACING_HORIZONTAL, (Comparable)newFacing.get());
        }
        return empty;
    }

    private static Optional<Direction> findAttacheablePost(BlockPos transformerPos, BlockGetter world, Direction preferred) {
        Optional<Direction> ret = Optional.empty();
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            if (!PostTransformerBlock.isAttacheablePost(transformerPos.m_142300_(d), world)) continue;
            ret = Optional.of(d);
            if (d == preferred) break;
        }
        return ret;
    }

    public static boolean isAttacheablePost(BlockPos possiblePost, BlockGetter w) {
        BlockState postState = w.m_8055_(possiblePost);
        if (!(postState.m_60734_() instanceof IPostBlock)) {
            return false;
        }
        IPostBlock post = (IPostBlock)postState.m_60734_();
        return post.canConnectTransformer(w, possiblePost);
    }
}

