/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeSerializer
extends IERecipeSerializer<RefineryRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.REFINERY);
    }

    @Override
    public RefineryRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        FluidStack output = ApiUtils.jsonDeserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        FluidTagInput input0 = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input0"));
        FluidTagInput input1 = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input1"));
        Ingredient catalyst = Ingredient.f_43901_;
        if (json.has("catalyst")) {
            catalyst = Ingredient.m_43917_((JsonElement)json.get("catalyst"));
        }
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        RefineryRecipe recipe = new RefineryRecipe(recipeId, output, input0, input1, catalyst, energy);
        recipe.modifyTimeAndEnergy(() -> 1.0, IEServerConfig.MACHINES.refineryConfig);
        return recipe;
    }

    @Nullable
    public RefineryRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        FluidStack output = buffer.readFluidStack();
        FluidTagInput input0 = FluidTagInput.read(buffer);
        FluidTagInput input1 = FluidTagInput.read(buffer);
        Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        return new RefineryRecipe(recipeId, output, input0, input1, catalyst, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, RefineryRecipe recipe) {
        buffer.writeFluidStack(recipe.output);
        recipe.input0.write(buffer);
        recipe.input1.write(buffer);
        recipe.catalyst.m_43923_(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

