/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public abstract class IEProjectileEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Optional<UUID>> SHOOTER_PARAMETER = SynchedEntityData.m_135353_(IEProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected BlockPos stuckIn = null;
    protected BlockState inBlockState;
    public boolean f_36703_;
    public int ticksInGround;
    public int ticksInAir;
    protected IntSet piercedEntities;
    @Nullable
    protected UUID shooterUUID;
    private int tickLimit = 40;

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world) {
        super(type, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, double x, double y, double z) {
        this(type, world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_6034_(x, y, z);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, LivingEntity living, double ax, double ay, double az) {
        this(type, world, living, living.m_20185_(), living.m_20186_() + (double)living.m_20192_(), living.m_20189_(), ax, ay, az);
    }

    public IEProjectileEntity(EntityType<? extends IEProjectileEntity> type, Level world, LivingEntity living, double x, double y, double z, double ax, double ay, double az) {
        this(type, world);
        float yaw = living != null ? living.m_146908_() : 0.0f;
        float pitch = living != null ? living.m_146909_() : 0.0f;
        this.m_7678_(x, y, z, yaw, pitch);
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20334_(ax, ay, az);
        this.m_5602_((Entity)living);
        this.setShooterSynced();
        Vec3 motion = this.m_20184_();
        this.m_6686_(motion.f_82479_, motion.f_82480_, motion.f_82481_, 3.0f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOTER_PARAMETER, Optional.empty());
    }

    @Nonnull
    public EntityDimensions m_6972_(Pose poseIn) {
        return new EntityDimensions(0.125f, 0.125f, true);
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.f_19804_.m_135381_(SHOOTER_PARAMETER, Optional.ofNullable(this.shooterUUID));
    }

    public UUID getShooterSynced() {
        Optional s = (Optional)this.f_19804_.m_135370_(SHOOTER_PARAMETER);
        return s.orElse(null);
    }

    @Nullable
    public UUID getShooterUUID() {
        return this.shooterUUID;
    }

    @Nonnull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_8119_() {
        if (this.m_37282_() == null && this.f_19853_.f_46443_) {
            this.shooterUUID = this.getShooterSynced();
        }
        this.m_6075_();
        BlockState localState = this.stuckIn != null ? this.f_19853_.m_8055_(this.stuckIn) : Blocks.f_50016_.m_49966_();
        if (localState.m_60767_() != Material.f_76296_) {
            VoxelShape shape = localState.m_60812_((BlockGetter)this.f_19853_, this.stuckIn);
            for (AABB subbox : shape.m_83299_()) {
                if (!subbox.m_82393_(this.m_20185_(), this.m_20186_(), this.m_20189_())) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36703_) {
            if (localState == this.inBlockState) {
                ++this.ticksInGround;
                if (this.ticksInGround >= this.getMaxTicksInGround()) {
                    this.m_146870_();
                }
            } else {
                this.f_36703_ = false;
                this.m_20256_(this.m_20184_().m_82490_((double)(this.f_19796_.nextFloat() / 5.0f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            Vec3 nextPos;
            ++this.ticksInAir;
            if (this.ticksInAir >= this.tickLimit) {
                this.m_146870_();
                return;
            }
            Vec3 currentPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            BlockHitResult mop = this.f_19853_.m_45547_(new ClipContext(currentPos, nextPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (mop.m_6662_() == HitResult.Type.BLOCK) {
                nextPos = mop.m_82450_();
            }
            if (mop.m_6662_() != HitResult.Type.ENTITY) {
                Entity entity = null;
                List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), Entity::m_6087_);
                double d0 = 0.0;
                for (Entity entity1 : list) {
                    double d1;
                    if (!entity1.m_6087_() || entity1.m_142081_().equals(this.shooterUUID) && this.ticksInAir <= 5) continue;
                    float f = 0.3f;
                    AABB axisalignedbb = entity1.m_142469_().m_82377_((double)f, (double)f, (double)f);
                    Optional movingobjectposition1 = axisalignedbb.m_82371_(currentPos, nextPos);
                    if (!movingobjectposition1.isPresent() || !((d1 = currentPos.m_82554_((Vec3)movingobjectposition1.get())) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    mop = new EntityHitResult(entity);
                }
            }
            if (mop.m_6662_() != HitResult.Type.MISS) {
                if (mop.m_6662_() == HitResult.Type.ENTITY) {
                    Player shooter;
                    EntityHitResult entityHit = (EntityHitResult)mop;
                    if (!this.m_6060_() && this.canIgnite() && entityHit.m_82443_().m_6060_()) {
                        this.m_20254_(3);
                    }
                    boolean allowHit = true;
                    if (this.shooterUUID != null && (shooter = this.f_19853_.m_46003_(this.shooterUUID)) != null && entityHit.m_82443_() instanceof Player) {
                        allowHit = shooter.m_7099_((Player)entityHit.m_82443_());
                    }
                    if (allowHit) {
                        this.m_6532_((HitResult)mop);
                    }
                    this.handlePiecing(entityHit.m_82443_());
                } else if (mop.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult blockHit = mop;
                    this.m_6532_((HitResult)blockHit);
                    this.stuckIn = blockHit.m_82425_();
                    this.inBlockState = this.f_19853_.m_8055_(blockHit.m_82425_());
                    this.m_20256_(blockHit.m_82450_().m_82546_(this.m_20182_()));
                    float f2 = (float)this.m_20184_().m_82553_();
                    Vec3 motion = this.m_20184_();
                    this.m_6034_(this.m_20185_() - motion.f_82479_ / (double)f2 * 0.05, this.m_20186_() - motion.f_82480_ / (double)f2 * 0.05, this.m_20189_() - motion.f_82481_ / (double)f2 * 0.05);
                    this.f_36703_ = true;
                    if (this.inBlockState.m_60767_() != Material.f_76296_) {
                        this.inBlockState.m_60682_(this.f_19853_, blockHit.m_82425_(), (Entity)this);
                    }
                }
            }
            this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
            float absMotion = (float)this.m_20184_().m_82553_();
            this.m_146922_((float)(Math.atan2(this.m_20184_().f_82479_, this.m_20184_().f_82481_) * 180.0 / Math.PI));
            this.m_146926_((float)(Math.atan2(this.m_20184_().f_82480_, absMotion) * 180.0 / Math.PI));
            while (this.m_146909_() - this.f_19860_ < -180.0f) {
                this.f_19860_ -= 360.0f;
            }
            while (this.m_146909_() - this.f_19860_ >= 180.0f) {
                this.f_19860_ += 360.0f;
            }
            while (this.m_146908_() - this.f_19859_ < -180.0f) {
                this.f_19859_ -= 360.0f;
            }
            while (this.m_146908_() - this.f_19859_ >= 180.0f) {
                this.f_19859_ += 360.0f;
            }
            this.m_146926_(this.f_19860_ + (this.m_146909_() - this.f_19860_) * 0.2f);
            this.m_146922_(this.f_19859_ + (this.m_146908_() - this.f_19859_) * 0.2f);
            float movementDecay = this.getMotionDecayFactor();
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - this.m_20184_().f_82479_ * (double)f3, this.m_20186_() - this.m_20184_().f_82480_ * (double)f3, this.m_20189_() - this.m_20184_().f_82481_ * (double)f3, this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
                }
                movementDecay *= 0.8f;
            }
            if (movementDecay > 0.0f) {
                this.m_20256_(this.m_20184_().m_82490_((double)movementDecay).m_82520_(0.0, -this.getGravity(), 0.0));
            }
            this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_20101_();
        }
    }

    public void m_6123_(Player player) {
        if (!this.f_19853_.f_46443_ && (this.f_36703_ || this.m_36797_()) && this.f_36706_ <= 0) {
            boolean flag;
            boolean bl = flag = this.f_36705_ == AbstractArrow.Pickup.ALLOWED || this.f_36705_ == AbstractArrow.Pickup.CREATIVE_ONLY && player.m_150110_().f_35937_ || this.m_36797_() && this.m_37282_().m_142081_() == player.m_142081_();
            if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED && !player.m_150109_().m_36054_(this.m_7941_())) {
                flag = false;
            }
            if (flag) {
                player.m_7938_((Entity)this, 1);
                this.m_146870_();
            }
        }
    }

    protected void handlePiecing(Entity target) {
        if (this.m_36796_() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet((int)this.m_36796_());
            }
            if (this.piercedEntities.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.piercedEntities.add(target.m_142049_());
        } else {
            this.m_146870_();
        }
    }

    public boolean m_6783_(double distSq) {
        double d1 = this.m_142469_().m_82309_() * 4.0;
        return distSq < (d1 *= 64.0) * d1;
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    public abstract void m_6532_(HitResult var1);

    protected void m_8060_(BlockHitResult mop) {
        BlockState blockstate = this.f_19853_.m_8055_(mop.m_82425_());
        blockstate.m_60669_(this.f_19853_, blockstate, mop, (Projectile)this);
    }

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.inBlockState != null) {
            nbt.m_128365_("inPos", (Tag)NbtUtils.m_129224_((BlockPos)this.stuckIn));
            nbt.m_128365_("inTile", (Tag)NbtUtils.m_129202_((BlockState)this.inBlockState));
        }
        nbt.m_128344_("inGround", (byte)(this.f_36703_ ? 1 : 0));
        if (this.shooterUUID != null) {
            nbt.m_128362_("Owner", this.shooterUUID);
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("inTile", 10)) {
            this.inBlockState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("inTile"));
            this.stuckIn = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("inPos"));
        } else {
            this.inBlockState = null;
            this.stuckIn = null;
        }
        this.f_36703_ = nbt.m_128445_("inGround") == 1;
        this.shooterUUID = nbt.m_128441_("Owner") ? nbt.m_128342_("Owner") : null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_5602_(@Nullable Entity entityIn) {
        super.m_5602_(entityIn);
        if (entityIn != null) {
            this.shooterUUID = entityIn.m_142081_();
        }
    }
}

