/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class FaradaySuitItem
extends ArmorItem
implements IElectricEquipment {
    public static ArmorMaterial mat = new FaradayArmorMaterial();

    public FaradaySuitItem(EquipmentSlot type) {
        super(mat, type, new Item.Properties().m_41487_(1).m_41491_(ImmersiveEngineering.ITEM_GROUP));
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlot eqSlot, LivingEntity owner, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        if ((double)dmg.source.level < 1.75) {
            if (cache.containsKey("faraday")) {
                cache.put("faraday", 1 << this.f_40377_.m_20749_() | (Integer)cache.get("faraday"));
            } else {
                cache.put("faraday", 1 << this.f_40377_.m_20749_());
            }
            if (cache.containsKey("faraday") && (Integer)cache.get("faraday") == 15) {
                dmg.dmg = 0.0f;
            }
        } else {
            dmg.dmg = (float)((double)dmg.dmg * 1.2);
            if (!(owner instanceof Player && ((Player)owner).m_150110_().f_35937_ || !equipped.m_41629_(2, Utils.RAND, dmg.m_7639_() instanceof ServerPlayer ? (ServerPlayer)dmg.m_7639_() : null))) {
                owner.m_8061_(eqSlot, ItemStack.f_41583_);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "immersiveengineering:textures/models/armor_faraday" + (slot == EquipmentSlot.LEGS ? "_legs" : "") + ".png";
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private static class FaradayArmorMaterial
    implements ArmorMaterial {
        private FaradayArmorMaterial() {
        }

        public int m_7366_(@Nonnull EquipmentSlot slotIn) {
            return switch (slotIn) {
                case EquipmentSlot.FEET -> 13;
                case EquipmentSlot.LEGS -> 15;
                case EquipmentSlot.CHEST -> 16;
                case EquipmentSlot.HEAD -> 11;
                default -> 0;
            };
        }

        public int m_7365_(EquipmentSlot slotIn) {
            return switch (slotIn) {
                case EquipmentSlot.FEET, EquipmentSlot.HEAD -> 1;
                case EquipmentSlot.LEGS -> 2;
                case EquipmentSlot.CHEST -> 3;
                default -> 0;
            };
        }

        public int m_6646_() {
            return 0;
        }

        @Nonnull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11672_;
        }

        @Nonnull
        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        @Nonnull
        public String m_6082_() {
            return "immersiveengineering:faraday";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

