/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.client.render.tooltip.RevolverServerTooltip;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.ListUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;

public class SpeedloaderItem
extends InternalStorageItem
implements IEItemInterfaces.IBulletContainer {
    public SpeedloaderItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public int getSlotCount() {
        return 8;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            this.openGui(player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    @Nullable
    protected IEContainerTypes.ItemContainerType<?> getContainerType() {
        return IEContainerTypes.REVOLVER;
    }

    public boolean isEmpty(ItemStack stack) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack b = inv.getStackInSlot(i);
                if (b.m_41619_() || !(b.m_41720_() instanceof BulletItem)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Override
    public int getBulletCount(ItemStack container) {
        return this.getSlotCount();
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver) {
        return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getSlotCount()));
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return RevolverItem.copyBulletsToShareTag(stack, super.getShareTag(stack));
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        RevolverItem.readBulletsFromShareTag(stack, nbt);
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack pStack) {
        return Optional.of(new RevolverServerTooltip(this.getBullets(pStack), this.getBulletCount(pStack)));
    }
}

