/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class ToolboxItem
extends InternalStorageItem {
    public static final int SLOT_COUNT = 23;

    public ToolboxItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            this.openGui(player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    @Nullable
    protected IEContainerTypes.ItemContainerType<?> getContainerType() {
        return IEContainerTypes.TOOLBOX;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        if (player != null && player.m_6144_()) {
            Level world = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            Direction side = ctx.m_43719_();
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!block.m_6864_(state, new BlockPlaceContext(ctx))) {
                pos = pos.m_142300_(side);
            }
            if (stack.m_41613_() != 0 && player.m_36204_(pos, side, stack)) {
                BlockState toolbox = IEBlocks.MetalDevices.TOOLBOX.defaultBlockState();
                if (world.m_7731_(pos, toolbox, 3)) {
                    IEBlocks.MetalDevices.TOOLBOX.get().onIEBlockPlacedBy(new BlockPlaceContext(ctx), toolbox);
                    SoundType soundtype = world.m_8055_(pos).m_60734_().getSoundType(world.m_8055_(pos), (LevelReader)world, pos, (Entity)player);
                    world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6225_(ctx);
    }

    @Override
    public int getSlotCount() {
        return 23;
    }

    public boolean m_142095_() {
        return false;
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        if (stack.m_41782_()) {
            NonNullList items = this.getContainedItems(stack).stream().filter(s -> !s.m_41619_()).collect(NonNullList::m_122779_, AbstractList::add, AbstractCollection::addAll);
            return Optional.of(new BundleTooltip(items, 0));
        }
        return super.m_142422_(stack);
    }
}

