/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;

public class PacketUtils {
    public static <T> List<T> readList(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> readElement) {
        int numElements = buffer.m_130242_();
        ArrayList<T> result = new ArrayList<T>(numElements);
        for (int i = 0; i < numElements; ++i) {
            result.add(readElement.apply(buffer));
        }
        return result;
    }

    public static <T> void writeListReverse(FriendlyByteBuf buffer, List<T> toWrite, BiConsumer<FriendlyByteBuf, T> writeElement) {
        PacketUtils.writeList(buffer, toWrite, (t, buf) -> writeElement.accept((FriendlyByteBuf)buf, (Object)t));
    }

    public static <T> void writeList(FriendlyByteBuf buffer, List<T> toWrite, BiConsumer<T, FriendlyByteBuf> writeElement) {
        buffer.m_130130_(toWrite.size());
        for (T element : toWrite) {
            writeElement.accept(element, buffer);
        }
    }
}

