/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.util.ResettableCapability;
import java.util.function.Function;
import net.minecraftforge.common.util.LazyOptional;

public abstract class MultiblockCapability<T> {
    public static <BE, T> MultiblockCapability<T> make(BE owner, Function<BE, MultiblockCapability<T>> getCap, Function<BE, BE> getMaster, ResettableCapability<T> ownValue) {
        return new Impl<T, BE>(getCap, getMaster, owner, ownValue);
    }

    public abstract LazyOptional<T> get();

    public final <T2> LazyOptional<T2> getAndCast() {
        return this.get().cast();
    }

    private static final class Impl<T, BE>
    extends MultiblockCapability<T> {
        private final BE owner;
        private final ResettableCapability<T> ownValue;
        private final Function<BE, MultiblockCapability<T>> getCap;
        private final Function<BE, BE> getMaster;
        private LazyOptional<T> cached = LazyOptional.empty();

        public Impl(Function<BE, MultiblockCapability<T>> getCap, Function<BE, BE> getMaster, BE owner, ResettableCapability<T> ownValue) {
            this.owner = owner;
            this.getCap = getCap;
            this.getMaster = getMaster;
            this.ownValue = ownValue;
            this.ownValue.addResetListener(() -> this.cached.invalidate());
        }

        @Override
        public LazyOptional<T> get() {
            BE master;
            if (!this.cached.isPresent() && (master = this.getMaster.apply(this.owner)) != null) {
                this.cached = ((Impl)this.getCap.apply(master)).ownValue.getLO();
            }
            return this.cached;
        }
    }
}

