/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.orientation;

import com.google.common.base.Preconditions;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public enum RelativeBlockFace {
    FRONT,
    LEFT,
    BACK,
    RIGHT,
    UP,
    DOWN;


    public Direction forFront(Direction front, boolean mirror) {
        Preconditions.checkArgument((boolean)front.m_122434_().m_122479_());
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FRONT -> front;
            case LEFT -> {
                if (mirror) {
                    yield front.m_122428_();
                }
                yield front.m_122427_();
            }
            case BACK -> front.m_122424_();
            case RIGHT -> {
                if (mirror) {
                    yield front.m_122427_();
                }
                yield front.m_122428_();
            }
            case UP -> Direction.UP;
            case DOWN -> Direction.DOWN;
        };
    }

    public static RelativeBlockFace from(Direction front, boolean mirror, Direction absoluteFace) {
        Preconditions.checkArgument((boolean)front.m_122434_().m_122479_());
        if (absoluteFace == Direction.UP) {
            return UP;
        }
        if (absoluteFace == Direction.DOWN) {
            return DOWN;
        }
        int numRotations = Mth.m_14100_((int)(front.m_122416_() - absoluteFace.m_122416_()), (int)4);
        return switch (numRotations) {
            case 0 -> FRONT;
            case 1 -> {
                if (mirror) {
                    yield LEFT;
                }
                yield RIGHT;
            }
            case 2 -> BACK;
            case 3 -> {
                if (mirror) {
                    yield RIGHT;
                }
                yield LEFT;
            }
            default -> throw new IllegalStateException("Unexpected value: " + numRotations);
        };
    }
}

