/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class ManualElementEntity
extends SpecialManualElements {
    private final Lazy<RenderData> renderData = Lazy.of(() -> new RenderData(entityType, entityData));

    public ManualElementEntity(ManualInstance helper, EntityType<?> entityType, @Nullable CompoundTag entityData) {
        super(helper);
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mx, int my) {
        Entity entity = ((RenderData)this.renderData.get()).entity;
        float yOff = ((RenderData)this.renderData.get()).ySize - 4;
        float scale = ((RenderData)this.renderData.get()).scale;
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(transform.m_85850_().m_85861_());
        modelViewStack.m_85837_((double)(x + 60), (double)((float)y + yOff), 50.0);
        modelViewStack.m_85841_(-scale, scale, scale);
        PoseStack mobPoseStack = new PoseStack();
        mobPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        float pitch = yOff / 2.0f - (float)my;
        float yaw = 60 - mx;
        mobPoseStack.m_85845_(Vector3f.f_122222_.m_122240_((float)Math.atan(pitch / 40.0f) * 20.0f));
        entity.f_19855_ = (float)Math.atan(yaw / 40.0f) * 20.0f;
        float yRot = (float)Math.atan(yaw / 40.0f) * 40.0f;
        float xRot = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
        entity.m_146922_(yRot);
        entity.m_146922_(yRot);
        entity.m_146926_(xRot);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).f_20885_ = yRot;
            ((LivingEntity)entity).f_20886_ = yRot;
            ((LivingEntity)entity).f_20883_ = yRot;
        }
        RenderSystem.m_157182_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, mobPoseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return ((RenderData)this.renderData.get()).ySize;
    }

    private static class RenderData {
        final Entity entity;
        final float entitySize;
        final float scale;
        final int ySize;

        RenderData(EntityType<?> entityType, CompoundTag entityData) {
            this.entity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            if (entityData != null) {
                this.entity.m_20258_(entityData);
            }
            this.entitySize = Math.max(this.entity.m_20205_(), this.entity.m_20206_());
            this.scale = this.entitySize <= 1.0f ? 36.0f : (this.entitySize <= 3.0f ? 28.0f : 26.0f - this.entitySize);
            this.ySize = this.entitySize <= 2.0f ? 60 : 90;
        }
    }
}

