/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;

public class ManualElementImage
extends SpecialManualElements {
    private final ManualImage[] images;
    private final int size;

    public ManualElementImage(ManualInstance helper, ManualImage ... images) {
        super(helper);
        this.images = images;
        int size = 0;
        for (ManualImage image : images) {
            size += image.vSize + 5;
        }
        this.size = size;
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mx, int my) {
        int xOff;
        int yOff = 0;
        for (ManualImage image1 : this.images) {
            xOff = 60 - image1.uSize / 2;
            gui.m_93179_(transform, x + xOff - 2, y + yOff - 2, x + xOff + image1.uSize + 2, y + yOff + image1.vSize + 2, -1398964, -610215);
            gui.m_93179_(transform, x + xOff - 1, y + yOff - 1, x + xOff + image1.uSize + 1, y + yOff + image1.vSize + 1, -3764666, -4290492);
            yOff += image1.vSize + 5;
        }
        yOff = 0;
        for (ManualImage image : this.images) {
            xOff = 60 - image.uSize / 2;
            ManualUtils.drawTexturedRect(transform, image.resource, x + xOff, y + yOff, image.uSize, image.vSize, (float)image.uMin / 256.0f, (float)(image.uMin + image.uSize) / 256.0f, (float)image.vMin / 256.0f, (float)(image.vMin + image.vSize) / 256.0f);
            yOff += image.vSize + 5;
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return this.size;
    }

    public static class ManualImage {
        ResourceLocation resource;
        int uMin;
        int uSize;
        int vMin;
        int vSize;

        public ManualImage(ResourceLocation resource, int uMin, int uSize, int vMin, int vSize) {
            this.resource = resource;
            this.uMin = uMin;
            this.uSize = uSize;
            this.vMin = vMin;
            this.vSize = vSize;
        }
    }
}

