/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.fluids.particle.FluidParticleData;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class FluidFX {
    static Random r = new Random();

    public static void splash(BlockPos pos, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == Fluids.f_76191_) {
            return;
        }
        FluidState defaultState = fluid.m_76145_();
        if (defaultState == null || defaultState.m_76178_()) {
            return;
        }
        BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, defaultState.m_76188_());
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        for (int i = 0; i < 20; ++i) {
            Vec3 v = VecHelper.offsetRandomly(Vec3.f_82478_, r, 0.25f);
            FluidFX.particle((ParticleOptions)blockParticleData, center.m_82549_(v), v);
        }
    }

    public static ParticleOptions getFluidParticle(FluidStack fluid) {
        return new FluidParticleData(AllParticleTypes.FLUID_PARTICLE.get(), fluid);
    }

    public static ParticleOptions getDrippingParticle(FluidStack fluid) {
        Object particle = null;
        if (FluidHelper.isWater(fluid.getFluid())) {
            particle = ParticleTypes.f_123803_;
        }
        if (FluidHelper.isLava(fluid.getFluid())) {
            particle = ParticleTypes.f_123800_;
        }
        if (particle == null) {
            particle = new FluidParticleData(AllParticleTypes.FLUID_DRIP.get(), fluid);
        }
        return particle;
    }

    public static void spawnRimParticles(Level world, BlockPos pos, Direction side, int amount, ParticleOptions particle, float rimRadius) {
        Vec3 directionVec = Vec3.m_82528_((Vec3i)side.m_122436_());
        for (int i = 0; i < amount; ++i) {
            Vec3 vec = VecHelper.offsetRandomly(Vec3.f_82478_, r, 1.0f).m_82541_();
            vec = VecHelper.clampComponentWise(vec, rimRadius).m_82559_(VecHelper.axisAlingedPlaneOf(directionVec)).m_82549_(directionVec.m_82490_(0.45 + (double)(r.nextFloat() / 16.0f)));
            Vec3 m = vec.m_82490_((double)0.05f);
            vec = vec.m_82549_(VecHelper.getCenterOf((Vec3i)pos));
            world.m_7107_(particle, vec.f_82479_, vec.f_82480_ - 0.0625, vec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public static void spawnPouringLiquid(Level world, BlockPos pos, int amount, ParticleOptions particle, float rimRadius, Vec3 directionVec, boolean inbound) {
        for (int i = 0; i < amount; ++i) {
            Vec3 vec = VecHelper.offsetRandomly(Vec3.f_82478_, r, rimRadius * 0.75f);
            vec = vec.m_82559_(VecHelper.axisAlingedPlaneOf(directionVec)).m_82549_(directionVec.m_82490_(0.5 + (double)(r.nextFloat() / 4.0f)));
            Vec3 m = vec.m_82490_(0.25);
            Vec3 centerOf = VecHelper.getCenterOf((Vec3i)pos);
            vec = vec.m_82549_(centerOf);
            if (inbound) {
                vec = vec.m_82549_(m);
                m = centerOf.m_82549_(directionVec.m_82490_(0.5)).m_82546_(vec).m_82490_(0.0625);
            }
            world.m_7107_(particle, vec.f_82479_, vec.f_82480_ - 0.0625, vec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    private static void particle(ParticleOptions data, Vec3 pos, Vec3 motion) {
        FluidFX.world().m_7106_(data, pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    private static Level world() {
        return Minecraft.m_91087_().f_91073_;
    }
}

