/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FluidValveRenderer
extends KineticTileEntityRenderer {
    public FluidValveRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = te.m_58900_();
        SuperByteBuffer pointer = CachedBufferer.partial(AllBlockPartials.FLUID_VALVE_POINTER, blockState);
        Direction facing = (Direction)blockState.m_61143_((Property)FluidValveBlock.FACING);
        if (!(te instanceof FluidValveTileEntity)) {
            return;
        }
        FluidValveTileEntity valve = (FluidValveTileEntity)te;
        float pointerRotation = Mth.m_14179_((float)valve.pointer.getValue(partialTicks), (float)0.0f, (float)-90.0f);
        Direction.Axis pipeAxis = FluidValveBlock.getPipeAxis(blockState);
        Direction.Axis shaftAxis = KineticTileEntityRenderer.getRotationAxisOf(te);
        int pointerRotationOffset = 0;
        if (pipeAxis.m_122479_() && shaftAxis == Direction.Axis.X || pipeAxis.m_122478_()) {
            pointerRotationOffset = 90;
        }
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)pointer.centre()).rotateY(AngleHelper.horizontalAngle(facing))).rotateX(facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0))).rotateY((float)pointerRotationOffset + pointerRotation)).unCentre()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }
}

