/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.EmptyingRecipe;
import com.simibubi.create.foundation.utility.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class EmptyingByBasin {
    static RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public static boolean canItemBeEmptied(Level world, ItemStack stack) {
        if (stack.m_41720_() instanceof PotionItem) {
            return true;
        }
        wrapper.m_6836_(0, stack);
        if (AllRecipeTypes.EMPTYING.find(wrapper, world).isPresent()) {
            return true;
        }
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return false;
        }
        for (int i = 0; i < tank.getTanks(); ++i) {
            if (tank.getFluidInTank(i).getAmount() <= 0) continue;
            return true;
        }
        return false;
    }

    public static Pair<FluidStack, ItemStack> emptyItem(Level world, ItemStack stack, boolean simulate) {
        FluidStack resultingFluid = FluidStack.EMPTY;
        ItemStack resultingItem = ItemStack.f_41583_;
        if (stack.m_41720_() instanceof PotionItem) {
            return PotionFluidHandler.emptyPotion(stack, simulate);
        }
        wrapper.m_6836_(0, stack);
        Optional recipe = AllRecipeTypes.EMPTYING.find(wrapper, world);
        if (recipe.isPresent()) {
            EmptyingRecipe emptyingRecipe = (EmptyingRecipe)recipe.get();
            List<ItemStack> results = emptyingRecipe.rollResults();
            if (!simulate) {
                stack.m_41774_(1);
            }
            resultingItem = results.isEmpty() ? ItemStack.f_41583_ : results.get(0);
            resultingFluid = emptyingRecipe.getResultingFluid();
            return Pair.of(resultingFluid, resultingItem);
        }
        ItemStack split = stack.m_41777_();
        split.m_41764_(1);
        LazyOptional capability = split.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return Pair.of(resultingFluid, resultingItem);
        }
        resultingFluid = tank.drain(1000, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        resultingItem = tank.getContainer().m_41777_();
        if (!simulate) {
            stack.m_41774_(1);
        }
        return Pair.of(resultingFluid, resultingItem);
    }
}

