/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightProvider;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.light.ListenerStatus;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltInventory;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.ItemHandlerBeltSegment;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BeltTileEntity
extends KineticTileEntity {
    public Map<Entity, BeltMovementHandler.TransportedEntityInfo> passengers;
    public Optional<DyeColor> color;
    public int beltLength;
    public int index;
    public Direction lastInsert;
    public CasingType casing;
    protected BlockPos controller = BlockPos.f_121853_;
    protected BeltInventory inventory;
    protected LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    public CompoundTag trackerUpdateTag;
    @OnlyIn(value=Dist.CLIENT)
    public BeltLighter lighter;
    public static final ModelProperty<CasingType> CASING_PROPERTY = new ModelProperty();

    public BeltTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.casing = CasingType.NONE;
        this.color = Optional.empty();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::canInsertFrom).setInsertionHandler(this::tryInsertingFromSide));
        behaviours.add(new TransportedItemStackHandlerBehaviour(this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf));
    }

    @Override
    public void tick() {
        if (this.beltLength == 0) {
            BeltBlock.initBelt(this.f_58857_, this.f_58858_);
        }
        super.tick();
        if (!AllBlocks.BELT.has(this.f_58857_.m_8055_(this.f_58858_))) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.beltLength > 0 && this.lighter == null) {
                this.lighter = new BeltLighter();
            }
        });
        this.invalidateRenderBoundingBox();
        this.getInventory().tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<Entity, BeltMovementHandler.TransportedEntityInfo>();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = BeltMovementHandler.canBeTransported(entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > (this.m_58900_().m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            BeltMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    @Override
    public float calculateStressApplied() {
        if (!this.isController()) {
            return 0.0f;
        }
        return super.calculateStressApplied();
    }

    @Override
    public AABB createRenderBoundingBox() {
        if (!this.isController()) {
            return super.createRenderBoundingBox();
        }
        return super.createRenderBoundingBox().m_82400_((double)(this.beltLength + 1));
    }

    protected void initializeItemHandler() {
        if (this.f_58857_.f_46443_ || this.itemHandler.isPresent()) {
            return;
        }
        if (!this.f_58857_.m_46749_(this.controller)) {
            return;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return;
        }
        BeltInventory inventory = ((BeltTileEntity)te).getInventory();
        if (inventory == null) {
            return;
        }
        ItemHandlerBeltSegment handler = new ItemHandlerBeltSegment(inventory, this.index);
        this.itemHandler = LazyOptional.of(() -> handler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (side == Direction.UP || BeltBlock.canAccessFromSide(side, this.m_58900_()))) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.itemHandler.invalidate();
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.controller != null) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        compound.m_128379_("IsController", this.isController());
        compound.m_128405_("Length", this.beltLength);
        compound.m_128405_("Index", this.index);
        NBTHelper.writeEnum(compound, "Casing", this.casing);
        if (this.color.isPresent()) {
            NBTHelper.writeEnum(compound, "Dye", this.color.get());
        }
        if (this.isController()) {
            compound.m_128365_("Inventory", (Tag)this.getInventory().write());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        int prevBeltLength = this.beltLength;
        super.read(compound, clientPacket);
        if (compound.m_128471_("IsController")) {
            this.controller = this.f_58858_;
        }
        Optional<Object> optional = this.color = compound.m_128441_("Dye") ? Optional.of(NBTHelper.readEnum(compound, "Dye", DyeColor.class)) : Optional.empty();
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
            }
            this.trackerUpdateTag = compound;
            this.index = compound.m_128451_("Index");
            this.beltLength = compound.m_128451_("Length");
            if (prevBeltLength != this.beltLength) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    if (this.lighter != null) {
                        this.lighter.initializeLight();
                    }
                });
            }
        }
        if (this.isController()) {
            this.getInventory().read(compound.m_128469_("Inventory"));
        }
        CasingType casingBefore = this.casing;
        this.casing = NBTHelper.readEnum(compound, "Casing", CasingType.class);
        if (!clientPacket) {
            return;
        }
        if (casingBefore == this.casing) {
            return;
        }
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
    }

    @Override
    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.beltLength = 0;
        this.index = 0;
        this.controller = null;
        this.trackerUpdateTag = new CompoundTag();
    }

    public void applyColor(DyeColor colorIn) {
        if (colorIn == null ? !this.color.isPresent() : this.color.isPresent() && this.color.get() == colorIn) {
            return;
        }
        for (BlockPos blockPos : BeltBlock.getBeltChain(this.f_58857_, this.getController())) {
            BeltTileEntity belt = BeltHelper.getSegmentTE((LevelAccessor)this.f_58857_, blockPos);
            if (belt == null) continue;
            belt.color = Optional.ofNullable(colorIn);
            belt.m_6596_();
            belt.sendData();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((BlockEntity)belt));
        }
    }

    public BeltTileEntity getControllerTE() {
        if (this.controller == null) {
            return null;
        }
        if (!this.f_58857_.m_46749_(this.controller)) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return null;
        }
        return (BeltTileEntity)te;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
    }

    public BlockPos getController() {
        return this.controller == null ? this.f_58858_ : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public float getBeltMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = this.getBeltFacing().m_122421_().m_122540_();
        if (this.getBeltFacing().m_122434_() == Direction.Axis.X) {
            offset *= -1;
        }
        return this.getBeltMovementSpeed() * (float)offset;
    }

    public boolean hasPulley() {
        if (!AllBlocks.BELT.has(this.m_58900_())) {
            return false;
        }
        return this.m_58900_().m_61143_(BeltBlock.PART) != BeltPart.MIDDLE;
    }

    protected boolean isLastBelt() {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        Direction direction = this.getBeltFacing();
        if (this.m_58900_().m_61143_(BeltBlock.SLOPE) == BeltSlope.VERTICAL) {
            return false;
        }
        BeltPart part = (BeltPart)((Object)this.m_58900_().m_61143_(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return false;
        }
        boolean movingPositively = this.getSpeed() > 0.0f == (direction.m_122421_().m_122540_() == 1) ^ direction.m_122434_() == Direction.Axis.X;
        return part == BeltPart.START ^ movingPositively;
    }

    public Vec3i getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public Vec3i getBeltChainDirection() {
        return this.getMovementDirection(true, true);
    }

    protected Vec3i getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        boolean movingUp;
        boolean onSlope;
        boolean notHorizontal;
        if (this.getSpeed() == 0.0f) {
            return BlockPos.f_121853_;
        }
        BlockState blockState = this.m_58900_();
        Direction beltFacing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        BeltSlope slope = (BeltSlope)((Object)blockState.m_61143_(BeltBlock.SLOPE));
        BeltPart part = (BeltPart)((Object)blockState.m_61143_(BeltBlock.PART));
        Direction.Axis axis = beltFacing.m_122434_();
        Direction movementFacing = Direction.m_122390_((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
        boolean bl = notHorizontal = blockState.m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (this.getSpeed() < 0.0f) {
            movementFacing = movementFacing.m_122424_();
        }
        Vec3i movement = movementFacing.m_122436_();
        boolean slopeBeforeHalf = part == BeltPart.END == (beltFacing.m_122421_() == Direction.AxisDirection.POSITIVE);
        boolean bl2 = onSlope = notHorizontal && (part == BeltPart.MIDDLE || slopeBeforeHalf == firstHalf || ignoreHalves);
        boolean bl3 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD) ? true : (movingUp = false);
        if (!onSlope) {
            return movement;
        }
        return new Vec3i(movement.m_123341_(), movingUp ? 1 : -1, movement.m_123343_());
    }

    public Direction getMovementFacing() {
        Direction.Axis axis = this.getBeltFacing().m_122434_();
        return Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)(this.getBeltMovementSpeed() < 0.0f ^ axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    protected Direction getBeltFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public BeltInventory getInventory() {
        if (!this.isController()) {
            BeltTileEntity controllerTE = this.getControllerTE();
            if (controllerTE != null) {
                return controllerTE.getInventory();
            }
            return null;
        }
        if (this.inventory == null) {
            this.inventory = new BeltInventory(this);
        }
        return this.inventory;
    }

    private void applyToAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        BeltTileEntity controller = this.getControllerTE();
        if (controller == null) {
            return;
        }
        BeltInventory inventory = controller.getInventory();
        if (inventory != null) {
            inventory.applyToEachWithin((float)this.index + 0.5f, maxDistanceFromCenter, processFunction);
        }
    }

    private Vec3 getWorldPositionOf(TransportedItemStack transported) {
        BeltTileEntity controllerTE = this.getControllerTE();
        if (controllerTE == null) {
            return Vec3.f_82478_;
        }
        return BeltHelper.getVectorForOffset(controllerTE, transported.beltPosition);
    }

    public void setCasingType(CasingType type) {
        if (this.casing == type) {
            return;
        }
        if (this.casing != CasingType.NONE) {
            this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)(this.casing == CasingType.ANDESITE ? AllBlocks.ANDESITE_CASING.getDefaultState() : AllBlocks.BRASS_CASING.getDefaultState())));
        }
        this.casing = type;
        boolean shouldBlockHaveCasing = type != CasingType.NONE;
        BlockState blockState = this.m_58900_();
        if ((Boolean)blockState.m_61143_((Property)BeltBlock.CASING) != shouldBlockHaveCasing) {
            KineticTileEntity.switchToBlockState(this.f_58857_, this.f_58858_, (BlockState)blockState.m_61124_((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(shouldBlockHaveCasing)));
        }
        this.m_6596_();
        this.sendData();
    }

    private boolean canInsertFrom(Direction side) {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        BlockState state = this.m_58900_();
        if (state.m_61138_(BeltBlock.SLOPE) && (state.m_61143_(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS || state.m_61143_(BeltBlock.SLOPE) == BeltSlope.VERTICAL)) {
            return false;
        }
        return this.getMovementFacing() != side.m_122424_();
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        BrassTunnelTileEntity tunnelTE;
        BeltTileEntity nextBeltController = this.getControllerTE();
        ItemStack inserted = transportedStack.stack;
        ItemStack empty = ItemStack.f_41583_;
        if (nextBeltController == null) {
            return inserted;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null) {
            return inserted;
        }
        BlockEntity teAbove = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (teAbove instanceof BrassTunnelTileEntity && (tunnelTE = (BrassTunnelTileEntity)teAbove).hasDistributionBehaviour()) {
            if (!tunnelTE.getStackToDistribute().m_41619_()) {
                return inserted;
            }
            if (!tunnelTE.testFlapFilter(side.m_122424_(), inserted)) {
                return inserted;
            }
            if (!simulate) {
                BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.m_122424_(), true);
                tunnelTE.setStackToDistribute(inserted);
            }
            return empty;
        }
        if (this.getSpeed() == 0.0f) {
            return inserted;
        }
        if (this.getMovementFacing() == side.m_122424_()) {
            return inserted;
        }
        if (!nextInventory.canInsertAtFromSide(this.index, side)) {
            return inserted;
        }
        if (simulate) {
            return empty;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = (float)this.index + 0.5f - Math.signum(this.getDirectionAwareBeltMovementSpeed()) / 16.0f;
        Direction movementFacing = this.getMovementFacing();
        if (!side.m_122434_().m_122478_()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = (float)side.m_122421_().m_122540_() * 0.35f;
                if (side.m_122434_() == Direction.Axis.X) {
                    transportedStack.sideOffset *= -1.0f;
                }
            } else {
                transportedStack.beltPosition = this.getDirectionAwareBeltMovementSpeed() > 0.0f ? (float)this.index : (float)(this.index + 1);
            }
        }
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = this.index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.m_122424_(), true);
        nextInventory.addItem(transportedStack);
        nextBeltController.m_6596_();
        nextBeltController.sendData();
        return empty;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(CASING_PROPERTY, (Object)this.casing).build();
    }

    @Override
    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return state.m_61138_(BeltBlock.SLOPE) && (state.m_61143_(BeltBlock.SLOPE) == BeltSlope.UPWARD || state.m_61143_(BeltBlock.SLOPE) == BeltSlope.DOWNWARD);
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof BeltTileEntity && !connectedViaAxes) {
            return this.getController().equals((Object)((BeltTileEntity)target).getController()) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public void invalidateItemHandler() {
        this.itemHandler.invalidate();
    }

    public boolean shouldRenderNormally() {
        if (this.f_58857_ == null) {
            return this.isController();
        }
        BlockState state = this.m_58900_();
        return state != null && state.m_61138_(BeltBlock.PART) && state.m_61143_(BeltBlock.PART) == BeltPart.START;
    }

    public static enum CasingType {
        NONE,
        ANDESITE,
        BRASS;

    }

    @OnlyIn(value=Dist.CLIENT)
    class BeltLighter
    implements LightListener {
        private byte[] light;

        public BeltLighter() {
            this.initializeLight();
            LightUpdater.get((BlockAndTintGetter)BeltTileEntity.this.f_58857_).addListener((LightListener)this);
        }

        public int lightSegments() {
            return this.light == null ? 0 : this.light.length / 2;
        }

        public int getPackedLight(int segment) {
            return this.light == null ? 0 : LightTexture.m_109885_((int)this.light[segment * 2], (int)this.light[segment * 2 + 1]);
        }

        public GridAlignedBB getVolume() {
            BlockPos endPos = BeltHelper.getPositionForOffset(BeltTileEntity.this, BeltTileEntity.this.beltLength - 1);
            GridAlignedBB bb = GridAlignedBB.from((BlockPos)BeltTileEntity.this.f_58858_, (BlockPos)endPos);
            bb.fixMinMax();
            return bb;
        }

        public ListenerStatus status() {
            return BeltTileEntity.this.f_58859_ ? ListenerStatus.REMOVE : ListenerStatus.OKAY;
        }

        public void onLightUpdate(LightProvider world, LightLayer type, ImmutableBox changed) {
            if (BeltTileEntity.this.f_58859_) {
                return;
            }
            if (BeltTileEntity.this.f_58857_ == null) {
                return;
            }
            GridAlignedBB beltVolume = this.getVolume();
            if (beltVolume.intersects(changed)) {
                if (type == LightLayer.BLOCK) {
                    this.updateBlockLight();
                }
                if (type == LightLayer.SKY) {
                    this.updateSkyLight();
                }
            }
        }

        private void initializeLight() {
            this.light = new byte[BeltTileEntity.this.beltLength * 2];
            Vec3i vec = BeltTileEntity.this.getBeltFacing().m_122436_();
            BeltSlope slope = (BeltSlope)((Object)BeltTileEntity.this.m_58900_().m_61143_(BeltBlock.SLOPE));
            int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(BeltTileEntity.this.controller.m_123341_(), BeltTileEntity.this.controller.m_123342_(), BeltTileEntity.this.controller.m_123343_());
            for (int i = 0; i < BeltTileEntity.this.beltLength * 2; i += 2) {
                this.light[i] = (byte)BeltTileEntity.this.f_58857_.m_45517_(LightLayer.BLOCK, (BlockPos)pos);
                this.light[i + 1] = (byte)BeltTileEntity.this.f_58857_.m_45517_(LightLayer.SKY, (BlockPos)pos);
                pos.m_122184_(vec.m_123341_(), verticality, vec.m_123343_());
            }
        }

        private void updateBlockLight() {
            Vec3i vec = BeltTileEntity.this.getBeltFacing().m_122436_();
            BeltSlope slope = (BeltSlope)((Object)BeltTileEntity.this.m_58900_().m_61143_(BeltBlock.SLOPE));
            int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(BeltTileEntity.this.controller.m_123341_(), BeltTileEntity.this.controller.m_123342_(), BeltTileEntity.this.controller.m_123343_());
            for (int i = 0; i < BeltTileEntity.this.beltLength * 2; i += 2) {
                this.light[i] = (byte)BeltTileEntity.this.f_58857_.m_45517_(LightLayer.BLOCK, (BlockPos)pos);
                pos.m_122184_(vec.m_123341_(), verticality, vec.m_123343_());
            }
        }

        private void updateSkyLight() {
            Vec3i vec = BeltTileEntity.this.getBeltFacing().m_122436_();
            BeltSlope slope = (BeltSlope)((Object)BeltTileEntity.this.m_58900_().m_61143_(BeltBlock.SLOPE));
            int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(BeltTileEntity.this.controller.m_123341_(), BeltTileEntity.this.controller.m_123342_(), BeltTileEntity.this.controller.m_123343_());
            for (int i = 1; i < BeltTileEntity.this.beltLength * 2; i += 2) {
                this.light[i] = (byte)BeltTileEntity.this.f_58857_.m_45517_(LightLayer.SKY, (BlockPos)pos);
                pos.m_122184_(vec.m_123341_(), verticality, vec.m_123343_());
            }
        }
    }
}

