/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SpeedGaugeTileEntity
extends GaugeTileEntity {
    public SpeedGaugeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        float speed = Math.abs(this.getSpeed());
        this.color = Color.mixColors(IRotate.SpeedLevel.of(speed).getColor(), 0xFFFFFF, 0.25f);
        if (speed == 69.0f) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.SPEED_READ, (LevelAccessor)this.f_58857_, this.f_58858_, 6, GogglesItem::isWearingGoggles);
        }
        this.dialTarget = SpeedGaugeTileEntity.getDialTarget(speed);
        this.m_6596_();
    }

    public static float getDialTarget(float speed) {
        speed = Math.abs(speed);
        float medium = ((Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Double)AllConfigs.SERVER.kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get()).floatValue();
        float target = 0.0f;
        target = speed == 0.0f ? 0.0f : (speed < medium ? Mth.m_14179_((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? Mth.m_14179_((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : Mth.m_14179_((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f)));
        return target;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("gui.speedometer.title", new Object[0]).m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_(IRotate.SpeedLevel.getFormattedSpeedText(this.speed, this.isOverStressed())));
        return true;
    }
}

