/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.block.SchematicTableTileEntity;
import com.simibubi.create.content.schematics.item.SchematicAndQuillItem;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CSchematics;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ServerSchematicLoader {
    private Map<String, SchematicUploadEntry> activeUploads = new HashMap<String, SchematicUploadEntry>();

    public String getSchematicPath() {
        return "schematics/uploaded";
    }

    public void tick() {
        HashSet<String> deadEntries = new HashSet<String>();
        for (String upload : this.activeUploads.keySet()) {
            SchematicUploadEntry entry = this.activeUploads.get(upload);
            if (entry.idleTime++ <= (Integer)this.getConfig().schematicIdleTimeout.get()) continue;
            Create.LOGGER.warn("Schematic Upload timed out: " + upload);
            deadEntries.add(upload);
        }
        deadEntries.forEach(this::cancelUpload);
    }

    public void shutdown() {
        new HashSet<String>(this.activeUploads.keySet()).forEach(this::cancelUpload);
    }

    public void handleNewUpload(ServerPlayer player, String schematic, long size, BlockPos pos) {
        String playerPath = this.getSchematicPath() + "/" + player.m_36316_().getName();
        String playerSchematicId = player.m_36316_().getName() + "/" + schematic;
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.LOGGER.warn("Attempted Schematic Upload with non-supported Format: " + playerSchematicId);
            return;
        }
        Path playerSchematicsPath = Paths.get(this.getSchematicPath(), player.m_36316_().getName()).toAbsolutePath();
        Path uploadPath = playerSchematicsPath.resolve(schematic).normalize();
        if (!uploadPath.startsWith(playerSchematicsPath)) {
            Create.LOGGER.warn("Attempted Schematic Upload with directory escape: {}", (Object)playerSchematicId);
            return;
        }
        if (!this.validateSchematicSizeOnServer(player, size)) {
            return;
        }
        if (this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        try {
            long count;
            SchematicTableTileEntity table = this.getTable(player.m_20193_(), pos);
            if (table == null) {
                return;
            }
            Files.deleteIfExists(uploadPath);
            try (Stream<Path> list = Files.list(Paths.get(playerPath, new String[0]));){
                count = list.count();
            }
            if (count >= (long)((Integer)this.getConfig().maxSchematics.get()).intValue()) {
                Stream<Path> list2 = Files.list(Paths.get(playerPath, new String[0]));
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            OutputStream writer = Files.newOutputStream(uploadPath, new OpenOption[0]);
            this.activeUploads.put(playerSchematicId, new SchematicUploadEntry(writer, size, (Level)player.m_183503_(), pos));
            table.startUpload(schematic);
        }
        catch (IOException e) {
            Create.LOGGER.error("Exception Thrown when starting Upload: " + playerSchematicId);
            e.printStackTrace();
        }
    }

    protected boolean validateSchematicSizeOnServer(ServerPlayer player, long size) {
        Integer maxFileSize = (Integer)this.getConfig().maxTotalSchematicSize.get();
        if (size > (long)(maxFileSize * 1000)) {
            player.m_6352_((Component)new TranslatableComponent("create.schematics.uploadTooLarge").m_7220_((Component)new TextComponent(" (" + size / 1000L + " KB).")), player.m_142081_());
            player.m_6352_((Component)new TranslatableComponent("create.schematics.maxAllowedSize").m_7220_((Component)new TextComponent(" " + maxFileSize + " KB")), player.m_142081_());
            return false;
        }
        return true;
    }

    public CSchematics getConfig() {
        return AllConfigs.SERVER.schematics;
    }

    public void handleWriteRequest(ServerPlayer player, String schematic, byte[] data) {
        String playerSchematicId = player.m_36316_().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            SchematicUploadEntry entry = this.activeUploads.get(playerSchematicId);
            entry.bytesUploaded += (long)data.length;
            if (data.length > (Integer)this.getConfig().maxSchematicPacketSize.get()) {
                Create.LOGGER.warn("Oversized Upload Packet received: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            if (entry.bytesUploaded > entry.totalBytes) {
                Create.LOGGER.warn("Received more data than Expected: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            try {
                entry.stream.write(data);
                entry.idleTime = 0;
                SchematicTableTileEntity table = this.getTable(entry.world, entry.tablePos);
                if (table == null) {
                    return;
                }
                table.uploadingProgress = (float)((double)entry.bytesUploaded / (double)entry.totalBytes);
                table.sendUpdate = true;
            }
            catch (IOException e) {
                Create.LOGGER.error("Exception Thrown when uploading Schematic: " + playerSchematicId);
                e.printStackTrace();
                this.cancelUpload(playerSchematicId);
            }
        }
    }

    protected void cancelUpload(String playerSchematicId) {
        if (!this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        SchematicUploadEntry entry = this.activeUploads.remove(playerSchematicId);
        try {
            entry.stream.close();
            Files.deleteIfExists(Paths.get(this.getSchematicPath(), playerSchematicId));
            Create.LOGGER.warn("Cancelled Schematic Upload: " + playerSchematicId);
        }
        catch (IOException e) {
            Create.LOGGER.error("Exception Thrown when cancelling Upload: " + playerSchematicId);
            e.printStackTrace();
        }
        BlockPos pos = entry.tablePos;
        if (pos == null) {
            return;
        }
        SchematicTableTileEntity table = this.getTable(entry.world, pos);
        if (table != null) {
            table.finishUpload();
        }
    }

    public SchematicTableTileEntity getTable(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof SchematicTableTileEntity)) {
            return null;
        }
        SchematicTableTileEntity table = (SchematicTableTileEntity)te;
        return table;
    }

    public void handleFinishedUpload(ServerPlayer player, String schematic) {
        String playerSchematicId = player.m_36316_().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            try {
                this.activeUploads.get((Object)playerSchematicId).stream.close();
                SchematicUploadEntry removed = this.activeUploads.remove(playerSchematicId);
                Level world = removed.world;
                BlockPos pos = removed.tablePos;
                Create.LOGGER.info("New Schematic Uploaded: " + playerSchematicId);
                if (pos == null) {
                    return;
                }
                BlockState blockState = world.m_8055_(pos);
                if (AllBlocks.SCHEMATIC_TABLE.get() != blockState.m_60734_()) {
                    return;
                }
                SchematicTableTileEntity table = this.getTable(world, pos);
                if (table == null) {
                    return;
                }
                table.finishUpload();
                table.inventory.setStackInSlot(1, SchematicItem.create(schematic, player.m_36316_().getName()));
            }
            catch (IOException e) {
                Create.LOGGER.error("Exception Thrown when finishing Upload: " + playerSchematicId);
                e.printStackTrace();
            }
        }
    }

    public void handleInstantSchematic(ServerPlayer player, String schematic, Level world, BlockPos pos, BlockPos bounds) {
        String playerPath = this.getSchematicPath() + "/" + player.m_36316_().getName();
        String playerSchematicId = player.m_36316_().getName() + "/" + schematic;
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.LOGGER.warn("Attempted Schematic Upload with non-supported Format: {}", (Object)playerSchematicId);
            return;
        }
        Path schematicPath = Paths.get(this.getSchematicPath(), new String[0]).toAbsolutePath();
        Path path = schematicPath.resolve(playerSchematicId).normalize();
        if (!path.startsWith(schematicPath)) {
            Create.LOGGER.warn("Attempted Schematic Upload with directory escape: {}", (Object)playerSchematicId);
            return;
        }
        if (!AllItems.SCHEMATIC_AND_QUILL.isIn(player.m_21205_())) {
            return;
        }
        try {
            long count;
            Files.deleteIfExists(path);
            try (Stream<Path> list = Files.list(Paths.get(playerPath, new String[0]));){
                count = list.count();
            }
            if (count >= (long)((Integer)this.getConfig().maxSchematics.get()).intValue()) {
                Stream<Path> list2 = Files.list(Paths.get(playerPath, new String[0]));
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            StructureTemplate t = new StructureTemplate();
            t.m_163802_(world, pos, (Vec3i)bounds, true, Blocks.f_50016_);
            try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                CompoundTag nbttagcompound = t.m_74618_(new CompoundTag());
                SchematicAndQuillItem.replaceStructureVoidWithAir(nbttagcompound);
                NbtIo.m_128947_((CompoundTag)nbttagcompound, (OutputStream)outputStream);
                player.m_21008_(InteractionHand.MAIN_HAND, SchematicItem.create(schematic, player.m_36316_().getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            Create.LOGGER.error("Exception Thrown in direct Schematic Upload: " + playerSchematicId);
            e.printStackTrace();
        }
    }

    public class SchematicUploadEntry {
        public Level world;
        public BlockPos tablePos;
        public OutputStream stream;
        public long bytesUploaded;
        public long totalBytes;
        public int idleTime;

        public SchematicUploadEntry(OutputStream stream, long totalBytes, Level world, BlockPos tablePos) {
            this.stream = stream;
            this.totalBytes = totalBytes;
            this.tablePos = tablePos;
            this.world = world;
            this.bytesUploaded = 0L;
            this.idleTime = 0;
        }
    }
}

