/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public abstract class Outline {
    protected OutlineParams params = new OutlineParams();
    protected Matrix3f transformNormals;

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, float var3);

    public void tick() {
    }

    public OutlineParams getParams() {
        return this.params;
    }

    public void renderCuboidLine(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 start, Vec3 end) {
        Vec3 diff = end.m_82546_(start);
        float hAngle = AngleHelper.deg(Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_));
        float hDistance = (float)diff.m_82542_(1.0, 0.0, 1.0).m_82553_();
        float vAngle = AngleHelper.deg(Mth.m_14136_((double)hDistance, (double)diff.f_82480_)) - 90.0f;
        ms.m_85836_();
        ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).translate(start)).rotateY((double)hAngle)).rotateX((double)vAngle);
        this.renderAACuboidLine(ms, buffer, Vec3.f_82478_, new Vec3(0.0, 0.0, diff.m_82553_()));
        ms.m_85849_();
    }

    public void renderAACuboidLine(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 start, Vec3 end) {
        float lineWidth = this.params.getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        VertexConsumer builder = buffer.m_6299_(RenderTypes.getOutlineSolid());
        Vec3 diff = end.m_82546_(start);
        if (diff.f_82479_ + diff.f_82480_ + diff.f_82481_ < 0.0) {
            Vec3 temp = start;
            start = end;
            end = temp;
            diff = diff.m_82490_(-1.0);
        }
        Vec3 extension = diff.m_82541_().m_82490_((double)(lineWidth / 2.0f));
        Vec3 plane = VecHelper.axisAlingedPlaneOf(diff);
        Direction face = Direction.m_122366_((double)diff.f_82479_, (double)diff.f_82480_, (double)diff.f_82481_);
        Direction.Axis axis = face.m_122434_();
        start = start.m_82546_(extension);
        end = end.m_82549_(extension);
        plane = plane.m_82490_((double)(lineWidth / 2.0f));
        Vec3 a1 = plane.m_82549_(start);
        Vec3 b1 = plane.m_82549_(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3 a2 = plane.m_82549_(start);
        Vec3 b2 = plane.m_82549_(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3 a3 = plane.m_82549_(start);
        Vec3 b3 = plane.m_82549_(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3 a4 = plane.m_82549_(start);
        Vec3 b4 = plane.m_82549_(end);
        if (this.params.disableNormals) {
            face = Direction.UP;
            this.putQuad(ms, builder, b4, b3, b2, b1, face);
            this.putQuad(ms, builder, a1, a2, a3, a4, face);
            this.putQuad(ms, builder, a1, b1, b2, a2, face);
            this.putQuad(ms, builder, a2, b2, b3, a3, face);
            this.putQuad(ms, builder, a3, b3, b4, a4, face);
            this.putQuad(ms, builder, a4, b4, b1, a1, face);
            return;
        }
        this.putQuad(ms, builder, b4, b3, b2, b1, face);
        this.putQuad(ms, builder, a1, a2, a3, a4, face.m_122424_());
        Vec3 vec = a1.m_82546_(a4);
        face = Direction.m_122366_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_);
        this.putQuad(ms, builder, a1, b1, b2, a2, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = Direction.m_122366_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_);
        this.putQuad(ms, builder, a2, b2, b3, a3, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = Direction.m_122366_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_);
        this.putQuad(ms, builder, a3, b3, b4, a4, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = Direction.m_122366_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_);
        this.putQuad(ms, builder, a4, b4, b1, a1, face);
    }

    public void putQuad(PoseStack ms, VertexConsumer builder, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, Direction normal) {
        this.putQuadUV(ms, builder, v1, v2, v3, v4, 0.0f, 0.0f, 1.0f, 1.0f, normal);
    }

    public void putQuadUV(PoseStack ms, VertexConsumer builder, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, float minU, float minV, float maxU, float maxV, Direction normal) {
        this.putVertex(ms, builder, v1, minU, minV, normal);
        this.putVertex(ms, builder, v2, maxU, minV, normal);
        this.putVertex(ms, builder, v3, maxU, maxV, normal);
        this.putVertex(ms, builder, v4, minU, maxV, normal);
    }

    protected void putVertex(PoseStack ms, VertexConsumer builder, Vec3 pos, float u, float v, Direction normal) {
        this.putVertex(ms.m_85850_(), builder, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, u, v, normal);
    }

    protected void putVertex(PoseStack.Pose pose, VertexConsumer builder, float x, float y, float z, float u, float v, Direction normal) {
        Color rgb = this.params.rgb;
        if (this.transformNormals == null) {
            this.transformNormals = pose.m_85864_();
        }
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        if (normal != null) {
            xOffset = normal.m_122429_();
            yOffset = normal.m_122430_();
            zOffset = normal.m_122431_();
        }
        builder.m_85982_(pose.m_85861_(), x, y, z).m_85950_(rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), rgb.getAlphaAsFloat() * this.params.alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(this.params.lightMap).m_85977_(pose.m_85864_(), (float)xOffset, (float)yOffset, (float)zOffset).m_5752_();
        this.transformNormals = null;
    }

    public static class OutlineParams {
        protected Optional<AllSpecialTextures> faceTexture;
        protected Optional<AllSpecialTextures> hightlightedFaceTexture = Optional.empty();
        protected Direction highlightedFace;
        protected boolean fadeLineWidth = true;
        protected boolean disableCull;
        protected boolean disableNormals;
        protected float alpha = 1.0f;
        protected int lightMap = 0xF000F0;
        protected Color rgb;
        private float lineWidth = 0.03125f;

        public OutlineParams() {
            this.faceTexture = this.hightlightedFaceTexture;
            this.rgb = Color.WHITE;
        }

        public OutlineParams colored(int color) {
            this.rgb = new Color(color, false);
            return this;
        }

        public OutlineParams colored(Color c) {
            this.rgb = c.copy();
            return this;
        }

        public OutlineParams lightMap(int light) {
            this.lightMap = light;
            return this;
        }

        public OutlineParams lineWidth(float width) {
            this.lineWidth = width;
            return this;
        }

        public OutlineParams withFaceTexture(AllSpecialTextures texture) {
            this.faceTexture = Optional.ofNullable(texture);
            return this;
        }

        public OutlineParams clearTextures() {
            return this.withFaceTextures(null, null);
        }

        public OutlineParams withFaceTextures(AllSpecialTextures texture, AllSpecialTextures highlightTexture) {
            this.faceTexture = Optional.ofNullable(texture);
            this.hightlightedFaceTexture = Optional.ofNullable(highlightTexture);
            return this;
        }

        public OutlineParams highlightFace(@Nullable Direction face) {
            this.highlightedFace = face;
            return this;
        }

        public OutlineParams disableNormals() {
            this.disableNormals = true;
            return this;
        }

        public OutlineParams disableCull() {
            this.disableCull = true;
            return this;
        }

        public float getLineWidth() {
            return this.fadeLineWidth ? this.alpha * this.lineWidth : this.lineWidth;
        }

        public Direction getHighlightedFace() {
            return this.highlightedFace;
        }
    }
}

