/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.foundation.worldgen.ConfigDrivenOreConfiguration;
import com.simibubi.create.foundation.worldgen.LayerPattern;
import com.simibubi.create.foundation.worldgen.OreFeatureBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class LayeredOreFeature
extends OreFeatureBase {
    public static final Map<ResourceLocation, List<LayerPattern>> LAYER_PATTERNS = new HashMap<ResourceLocation, List<LayerPattern>>();
    public static final LayeredOreFeature INSTANCE = new LayeredOreFeature();

    public LayeredOreFeature() {
        this.setRegistryName("config_driven_layered_ore");
    }

    public boolean m_142674_(FeaturePlaceContext<ConfigDrivenOreConfiguration> pContext) {
        Random random = pContext.m_159776_();
        BlockPos blockpos = pContext.m_159777_();
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        ConfigDrivenOreConfiguration config = (ConfigDrivenOreConfiguration)pContext.m_159778_();
        List<LayerPattern> patternPool = config.getLayers();
        if (patternPool.isEmpty()) {
            return false;
        }
        LayerPattern layerPattern = patternPool.get(random.nextInt(patternPool.size()));
        int placedAmount = 0;
        int size = config.getSize();
        int radius = Mth.m_14167_((float)((float)config.getSize() / 2.0f));
        int x0 = blockpos.m_123341_() - radius;
        int y0 = blockpos.m_123342_() - radius;
        int z0 = blockpos.m_123343_() - radius;
        int width = size + 1;
        int length = size + 1;
        int height = size + 1;
        if (blockpos.m_123342_() >= worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, blockpos.m_123341_(), blockpos.m_123343_())) {
            return false;
        }
        ArrayList<LayerPattern.Layer> resolvedLayers = new ArrayList<LayerPattern.Layer>();
        ArrayList<Float> layerDiameterOffsets = new ArrayList<Float>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BulkSectionAccess bulksectionaccess = new BulkSectionAccess((LevelAccessor)worldgenlevel);
        int layerCoordinate = random.nextInt(4);
        int slantyCoordinate = random.nextInt(3);
        float slope = random.nextFloat() * 0.75f;
        try {
            for (int x = 0; x < width; ++x) {
                float dx = (float)x * 2.0f / (float)width - 1.0f;
                if (dx * dx > 1.0f) continue;
                for (int y = 0; y < height; ++y) {
                    float dy = (float)y * 2.0f / (float)height - 1.0f;
                    if (dx * dx + dy * dy > 1.0f || worldgenlevel.m_151562_(y0 + y)) continue;
                    block7: for (int z = 0; z < length; ++z) {
                        LevelChunkSection levelchunksection;
                        int layerIndex;
                        float dz = (float)z * 2.0f / (float)height - 1.0f;
                        int n = layerCoordinate == 0 ? z : (layerIndex = layerCoordinate == 1 ? x : y);
                        if (slantyCoordinate != layerCoordinate) {
                            layerIndex = (int)((float)layerIndex + (float)Mth.m_14143_((float)(slantyCoordinate == 0 ? (float)z : (slantyCoordinate == 1 ? (float)x : (float)y))) * slope);
                        }
                        while (layerIndex >= resolvedLayers.size()) {
                            LayerPattern.Layer next = layerPattern.rollNext(resolvedLayers.isEmpty() ? null : (LayerPattern.Layer)resolvedLayers.get(resolvedLayers.size() - 1), random);
                            float offset = random.nextFloat() * 0.5f + 0.5f;
                            for (int i = 0; i < next.minSize + random.nextInt(1 + next.maxSize - next.minSize); ++i) {
                                resolvedLayers.add(next);
                                layerDiameterOffsets.add(Float.valueOf(offset));
                            }
                        }
                        if (dx * dx + dy * dy + dz * dz > 1.0f * ((Float)layerDiameterOffsets.get(layerIndex)).floatValue()) continue;
                        LayerPattern.Layer layer = (LayerPattern.Layer)resolvedLayers.get(layerIndex);
                        List<OreConfiguration.TargetBlockState> state = layer.rollBlock(random);
                        int currentX = x0 + x;
                        int currentY = y0 + y;
                        int currentZ = z0 + z;
                        mutablePos.m_122178_(currentX, currentY, currentZ);
                        if (!worldgenlevel.m_180807_((BlockPos)mutablePos) || (levelchunksection = bulksectionaccess.m_156104_((BlockPos)mutablePos)) == null) continue;
                        int i3 = SectionPos.m_123207_((int)currentX);
                        int j3 = SectionPos.m_123207_((int)currentY);
                        int k3 = SectionPos.m_123207_((int)currentZ);
                        BlockState blockstate = levelchunksection.m_62982_(i3, j3, k3);
                        for (OreConfiguration.TargetBlockState oreconfiguration$targetblockstate : state) {
                            if (!this.canPlaceOre(blockstate, arg_0 -> ((BulkSectionAccess)bulksectionaccess).m_156110_(arg_0), random, config, oreconfiguration$targetblockstate, mutablePos) || oreconfiguration$targetblockstate.f_161033_.m_60795_()) continue;
                            levelchunksection.m_62991_(i3, j3, k3, oreconfiguration$targetblockstate.f_161033_, false);
                            ++placedAmount;
                            continue block7;
                        }
                    }
                }
            }
        }
        finally {
            bulksectionaccess.close();
        }
        return placedAmount > 0;
    }
}

