/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.render.MultiTextureBuilder;
import net.optifine.render.MultiTextureData;
import net.optifine.render.RenderEnv;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.util.BufferUtil;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class BufferBuilder
extends DefaultedVertexConsumer
implements BufferVertexConsumer {
    private static final int f_166763_ = 0x200000;
    private static final Logger f_85647_ = LogUtils.getLogger();
    private ByteBuffer f_85648_;
    private final List<DrawState> f_166764_ = Lists.newArrayList();
    private int f_166765_;
    private int f_85651_;
    private int f_85652_;
    private int f_85653_;
    private int f_85654_;
    @Nullable
    private VertexFormatElement f_85655_;
    private int f_85656_;
    private VertexFormat f_85658_;
    private VertexFormat.Mode f_85657_;
    private boolean f_85659_;
    private boolean f_85660_;
    private boolean f_85661_;
    @Nullable
    private Vector3f[] f_166766_;
    private float f_166767_ = Float.NaN;
    private float f_166768_ = Float.NaN;
    private float f_166769_ = Float.NaN;
    private boolean f_166762_;
    private RenderType renderType;
    private boolean renderBlocks;
    private TextureAtlasSprite[] quadSprites = null;
    private TextureAtlasSprite[] quadSpritesPrev = null;
    private int[] quadOrdering = null;
    private TextureAtlasSprite quadSprite = null;
    private MultiTextureBuilder multiTextureBuilder = new MultiTextureBuilder();
    public SVertexBuilder sVertexBuilder;
    public RenderEnv renderEnv = null;
    public BitSet animatedSprites = null;
    public BitSet animatedSpritesCached = new BitSet();
    private ByteBuffer byteBufferTriangles;
    private Vector3f tempVec3f = new Vector3f();
    private float[] tempFloat4 = new float[4];
    private int[] tempInt4 = new int[4];
    private IntBuffer intBuffer;
    private FloatBuffer floatBuffer;
    private MultiBufferSource.BufferSource renderTypeBuffer;
    private FloatBuffer floatBufferSort;
    private VertexPosition[] quadVertexPositions;
    private Vector3f midBlock = new Vector3f();

    public BufferBuilder(int bufferSizeIn) {
        this.f_85648_ = MemoryTracker.m_182527_((int)(bufferSizeIn * 6));
        this.intBuffer = this.f_85648_.asIntBuffer();
        this.floatBuffer = this.f_85648_.asFloatBuffer();
        SVertexBuilder.initVertexBuilder((BufferBuilder)this);
    }

    private void m_85665_() {
        this.m_85722_(this.f_85658_.m_86020_());
    }

    private void m_85722_(int increaseAmount) {
        if (this.f_85652_ + increaseAmount > this.f_85648_.capacity()) {
            int i2 = this.f_85648_.capacity();
            int j2 = i2 + BufferBuilder.m_85725_((int)increaseAmount);
            f_85647_.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i2, (Object)j2);
            ByteBuffer bytebuffer = MemoryTracker.m_182529_((ByteBuffer)this.f_85648_, (int)j2);
            bytebuffer.rewind();
            this.f_85648_ = bytebuffer;
            this.intBuffer = this.f_85648_.asIntBuffer();
            this.floatBuffer = this.f_85648_.asFloatBuffer();
            if (this.quadSprites != null) {
                TextureAtlasSprite[] sprites = this.quadSprites;
                int quadSize = this.getBufferQuadSize();
                this.quadSprites = new TextureAtlasSprite[quadSize];
                System.arraycopy(sprites, 0, this.quadSprites, 0, Math.min(sprites.length, this.quadSprites.length));
                this.quadSpritesPrev = null;
            }
        }
    }

    private static int m_85725_(int xIn) {
        int j2;
        int i2 = 0x200000;
        if (xIn == 0) {
            return i2;
        }
        if (xIn < 0) {
            i2 *= -1;
        }
        return (j2 = xIn % i2) == 0 ? xIn : xIn + i2 - j2;
    }

    public void m_166771_(float cameraX, float cameraY, float cameraZ) {
        if (this.f_85657_ == VertexFormat.Mode.QUADS && (this.f_166767_ != cameraX || this.f_166768_ != cameraY || this.f_166769_ != cameraZ)) {
            this.f_166767_ = cameraX;
            this.f_166768_ = cameraY;
            this.f_166769_ = cameraZ;
            if (this.f_166766_ == null) {
                this.f_166766_ = this.m_166794_();
            }
        }
    }

    public SortState m_166770_() {
        TextureAtlasSprite[] quadSpritesNew = null;
        if (this.quadSprites != null) {
            int countQuads = this.f_85654_ / 4;
            quadSpritesNew = Arrays.copyOfRange(this.quadSprites, 0, countQuads);
        }
        return new SortState(this.f_85657_, this.f_85654_, this.f_166766_, this.f_166767_, this.f_166768_, this.f_166769_, quadSpritesNew);
    }

    public void m_166775_(SortState sortStateIn) {
        this.f_85648_.clear();
        this.f_85657_ = sortStateIn.f_166817_;
        this.f_85654_ = sortStateIn.f_166818_;
        this.f_85652_ = this.f_85651_;
        this.f_166766_ = sortStateIn.f_166819_;
        this.f_166767_ = sortStateIn.f_166820_;
        this.f_166768_ = sortStateIn.f_166821_;
        this.f_166769_ = sortStateIn.f_166822_;
        this.f_166762_ = true;
        if (this.quadSprites != null && sortStateIn.quadSprites != null) {
            System.arraycopy(sortStateIn.quadSprites, 0, this.quadSprites, 0, Math.min(sortStateIn.quadSprites.length, this.quadSprites.length));
        }
    }

    public void m_166779_(VertexFormat.Mode modeIn, VertexFormat formatIn) {
        if (this.f_85661_) {
            throw new IllegalStateException("Already building!");
        }
        this.f_85661_ = true;
        this.f_85657_ = modeIn;
        this.m_85704_(formatIn);
        this.f_85655_ = (VertexFormatElement)formatIn.m_86023_().get(0);
        this.f_85656_ = 0;
        this.f_85648_.clear();
        if (Config.isShaders()) {
            SVertexBuilder.endSetVertexFormat((BufferBuilder)this);
        }
        if (Config.isMultiTexture()) {
            this.initQuadSprites();
        }
        if (SmartAnimations.isActive()) {
            if (this.animatedSprites == null) {
                this.animatedSprites = this.animatedSpritesCached;
            }
            this.animatedSprites.clear();
        } else if (this.animatedSprites != null) {
            this.animatedSprites = null;
        }
    }

    public VertexConsumer m_7421_(float u, float v) {
        if (this.quadSprite != null && this.quadSprites != null) {
            u = this.quadSprite.toSingleU(u);
            v = this.quadSprite.toSingleV(v);
            this.quadSprites[this.f_85654_ / 4] = this.quadSprite;
        }
        return super.m_7421_(u, v);
    }

    private void m_85704_(VertexFormat vertexFormatIn) {
        if (this.f_85658_ != vertexFormatIn) {
            this.f_85658_ = vertexFormatIn;
            boolean flag = vertexFormatIn == DefaultVertexFormat.f_85812_;
            boolean flag1 = vertexFormatIn == DefaultVertexFormat.f_85811_;
            this.f_85659_ = flag || flag1;
            this.f_85660_ = flag;
        }
    }

    private IntConsumer m_166777_(VertexFormat.IndexType indexTypeIn) {
        switch (1.$SwitchMap$com$mojang$blaze3d$vertex$VertexFormat$IndexType[indexTypeIn.ordinal()]) {
            case 1: {
                return valueIn -> this.f_85648_.put((byte)valueIn);
            }
            case 2: {
                return valueIn -> this.f_85648_.putShort((short)valueIn);
            }
        }
        return valueIn -> this.f_85648_.putInt(valueIn);
    }

    private Vector3f[] m_166794_() {
        FloatBuffer floatbuffer = this.f_85648_.asFloatBuffer();
        int i2 = this.f_85651_ / 4;
        int j2 = this.f_85658_.m_86017_();
        int k2 = j2 * this.f_85657_.f_166948_;
        int l2 = this.f_85654_ / this.f_85657_.f_166948_;
        Vector3f[] avector3f = new Vector3f[l2];
        for (int i1 = 0; i1 < l2; ++i1) {
            float f2 = floatbuffer.get(i2 + i1 * k2 + 0);
            float f1 = floatbuffer.get(i2 + i1 * k2 + 1);
            float f22 = floatbuffer.get(i2 + i1 * k2 + 2);
            float f3 = floatbuffer.get(i2 + i1 * k2 + j2 * 2 + 0);
            float f4 = floatbuffer.get(i2 + i1 * k2 + j2 * 2 + 1);
            float f5 = floatbuffer.get(i2 + i1 * k2 + j2 * 2 + 2);
            float f6 = (f2 + f3) / 2.0f;
            float f7 = (f1 + f4) / 2.0f;
            float f8 = (f22 + f5) / 2.0f;
            avector3f[i1] = new Vector3f(f6, f7, f8);
        }
        return avector3f;
    }

    private void m_166786_(VertexFormat.IndexType indexTypeIn) {
        float[] afloat = new float[this.f_166766_.length];
        int[] aint = new int[this.f_166766_.length];
        int i2 = 0;
        while (i2 < this.f_166766_.length) {
            float f2 = this.f_166766_[i2].m_122239_() - this.f_166767_;
            float f1 = this.f_166766_[i2].m_122260_() - this.f_166768_;
            float f22 = this.f_166766_[i2].m_122269_() - this.f_166769_;
            afloat[i2] = f2 * f2 + f1 * f1 + f22 * f22;
            aint[i2] = i2++;
        }
        IntArrays.mergeSort((int[])aint, (index1, index2) -> Floats.compare((float)afloat[index2], (float)afloat[index1]));
        IntConsumer intconsumer = this.m_166777_(indexTypeIn);
        this.f_85648_.position(this.f_85652_);
        for (int j2 : aint) {
            intconsumer.accept(j2 * this.f_85657_.f_166948_ + 0);
            intconsumer.accept(j2 * this.f_85657_.f_166948_ + 1);
            intconsumer.accept(j2 * this.f_85657_.f_166948_ + 2);
            intconsumer.accept(j2 * this.f_85657_.f_166948_ + 2);
            intconsumer.accept(j2 * this.f_85657_.f_166948_ + 3);
            intconsumer.accept(j2 * this.f_85657_.f_166948_ + 0);
        }
        if (this.quadSprites != null) {
            this.quadOrdering = aint;
        }
    }

    public void m_85721_() {
        boolean flag;
        if (!this.f_85661_) {
            throw new IllegalStateException("Not building!");
        }
        int i2 = this.f_85657_.m_166958_(this.f_85654_);
        VertexFormat.IndexType vertexformat$indextype = VertexFormat.IndexType.m_166933_((int)i2);
        if (this.f_166766_ != null) {
            int j2 = Mth.m_144941_((int)(i2 * vertexformat$indextype.f_166924_), (int)4);
            this.m_85722_(j2);
            this.m_166786_(vertexformat$indextype);
            flag = false;
            this.f_85652_ += j2;
            this.f_85651_ += this.f_85654_ * this.f_85658_.m_86020_() + j2;
        } else {
            flag = true;
            this.f_85651_ += this.f_85654_ * this.f_85658_.m_86020_();
        }
        this.f_85661_ = false;
        MultiTextureData mtd = this.multiTextureBuilder.build(this.f_85654_, this.renderType, this.quadSprites, this.quadOrdering);
        this.f_166764_.add(new DrawState(this.f_85658_, this.f_85654_, i2, this.f_85657_, vertexformat$indextype, this.f_166762_, flag, mtd));
        this.renderType = null;
        this.renderBlocks = false;
        if (this.quadSprites != null) {
            this.quadSpritesPrev = this.quadSprites;
        }
        this.quadSprites = null;
        this.quadSprite = null;
        this.quadOrdering = null;
        this.f_85654_ = 0;
        this.f_85655_ = null;
        this.f_85656_ = 0;
        this.f_166766_ = null;
        this.f_166767_ = Float.NaN;
        this.f_166768_ = Float.NaN;
        this.f_166769_ = Float.NaN;
        this.f_166762_ = false;
    }

    public void m_5672_(int indexIn, byte byteIn) {
        this.f_85648_.put(this.f_85652_ + indexIn, byteIn);
    }

    public void m_5586_(int indexIn, short shortIn) {
        this.f_85648_.putShort(this.f_85652_ + indexIn, shortIn);
    }

    public void m_5832_(int indexIn, float floatIn) {
        this.f_85648_.putFloat(this.f_85652_ + indexIn, floatIn);
    }

    public void m_5752_() {
        if (this.f_85656_ != 0) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.f_85654_;
        this.m_85665_();
        if (this.f_85657_ == VertexFormat.Mode.LINES || this.f_85657_ == VertexFormat.Mode.LINE_STRIP) {
            int i2 = this.f_85658_.m_86020_();
            this.f_85648_.position(this.f_85652_);
            for (int pos = this.f_85652_ - i2; pos < this.f_85652_; ++pos) {
                this.f_85648_.put(this.f_85648_.get(pos));
            }
            this.f_85652_ += i2;
            ++this.f_85654_;
            this.m_85665_();
        }
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertex((BufferBuilder)this);
        }
    }

    public void m_5751_() {
        VertexFormatElement vertexformatelement;
        ImmutableList immutablelist = this.f_85658_.m_86023_();
        this.f_85656_ = (this.f_85656_ + 1) % immutablelist.size();
        this.f_85652_ += this.f_85655_.m_86050_();
        this.f_85655_ = vertexformatelement = (VertexFormatElement)immutablelist.get(this.f_85656_);
        if (vertexformatelement.m_86048_() == VertexFormatElement.Usage.PADDING) {
            this.m_5751_();
        }
        if (this.f_85824_ && this.f_85655_.m_86048_() == VertexFormatElement.Usage.COLOR) {
            super.m_6122_(this.f_85825_, this.f_85826_, this.f_85827_, this.f_85828_);
        }
    }

    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        return super.m_6122_(red, green, blue, alpha);
    }

    public void m_5954_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        if (this.f_85659_) {
            int i2;
            this.m_5832_(0, x);
            this.m_5832_(4, y);
            this.m_5832_(8, z);
            this.m_5672_(12, (byte)(red * 255.0f));
            this.m_5672_(13, (byte)(green * 255.0f));
            this.m_5672_(14, (byte)(blue * 255.0f));
            this.m_5672_(15, (byte)(alpha * 255.0f));
            this.m_5832_(16, texU);
            this.m_5832_(20, texV);
            if (this.f_85660_) {
                this.m_5586_(24, (short)(overlayUV & 0xFFFF));
                this.m_5586_(26, (short)(overlayUV >> 16 & 0xFFFF));
                i2 = 28;
            } else {
                i2 = 24;
            }
            this.m_5586_(i2 + 0, (short)(lightmapUV & 0xFFFF));
            this.m_5586_(i2 + 2, (short)(lightmapUV >> 16 & 0xFFFF));
            this.m_5672_(i2 + 4, BufferVertexConsumer.m_85774_((float)normalX));
            this.m_5672_(i2 + 5, BufferVertexConsumer.m_85774_((float)normalY));
            this.m_5672_(i2 + 6, BufferVertexConsumer.m_85774_((float)normalZ));
            this.f_85652_ += this.f_85658_.m_86020_();
            this.m_5752_();
        } else {
            super.m_5954_(x, y, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    public Pair<DrawState, ByteBuffer> m_85728_() {
        DrawState bufferbuilder$drawstate = (DrawState)this.f_166764_.get(this.f_166765_++);
        this.f_85648_.position(this.f_85653_);
        this.f_85653_ += Mth.m_144941_((int)bufferbuilder$drawstate.m_166813_(), (int)4);
        this.f_85648_.limit(this.f_85653_);
        if (this.f_166765_ == this.f_166764_.size() && this.f_85654_ == 0) {
            this.m_85729_();
        }
        ByteBuffer bytebuffer = this.f_85648_.slice();
        bytebuffer.order(this.f_85648_.order());
        this.f_85648_.clear();
        return Pair.of((Object)bufferbuilder$drawstate, (Object)bytebuffer);
    }

    public void m_85729_() {
        if (this.f_85651_ != this.f_85653_) {
            f_85647_.warn("Bytes mismatch {} {}", (Object)this.f_85651_, (Object)this.f_85653_);
        }
        this.m_85730_();
    }

    public void m_85730_() {
        this.f_85651_ = 0;
        this.f_85653_ = 0;
        this.f_85652_ = 0;
        this.f_166764_.clear();
        this.f_166765_ = 0;
        this.quadSprite = null;
    }

    public VertexFormatElement m_6297_() {
        if (this.f_85655_ == null) {
            throw new IllegalStateException("BufferBuilder not started");
        }
        return this.f_85655_;
    }

    public boolean m_85732_() {
        return this.f_85661_;
    }

    public void putSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.isTerrain() && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            int countQuads = this.f_85654_ / 4;
            this.quadSprites[countQuads] = sprite;
        }
    }

    public void setSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.isTerrain() && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            this.quadSprite = sprite;
        }
    }

    public boolean isMultiTexture() {
        return this.quadSprites != null;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderBlocks(boolean renderBlocks) {
        this.renderBlocks = renderBlocks;
        if (Config.isMultiTexture()) {
            this.initQuadSprites();
        }
    }

    public void setBlockLayer(RenderType layer) {
        this.renderType = layer;
        this.renderBlocks = true;
    }

    private void initQuadSprites() {
        if (!this.renderBlocks) {
            return;
        }
        if (this.renderType == null) {
            return;
        }
        if (this.quadSprites != null) {
            return;
        }
        if (!this.f_85661_) {
            return;
        }
        if (this.f_85654_ > 0) {
            VertexFormat.Mode drawModePrev = this.f_85657_;
            VertexFormat vertexFormatPrev = this.f_85658_;
            RenderType renderTypePrev = this.renderType;
            boolean renderBlocksPrev = this.renderBlocks;
            this.renderType.m_110412_(this, 0, 0, 0);
            this.m_166779_(drawModePrev, vertexFormatPrev);
            this.renderType = renderTypePrev;
            this.renderBlocks = renderBlocksPrev;
        }
        this.quadSprites = this.quadSpritesPrev;
        if (this.quadSprites == null || this.quadSprites.length < this.getBufferQuadSize()) {
            this.quadSprites = new TextureAtlasSprite[this.getBufferQuadSize()];
        }
    }

    private int getBufferQuadSize() {
        int quadSize = this.f_85648_.capacity() / this.f_85658_.m_86020_();
        return quadSize;
    }

    public RenderEnv getRenderEnv(BlockState blockStateIn, BlockPos blockPosIn) {
        if (this.renderEnv == null) {
            this.renderEnv = new RenderEnv(blockStateIn, blockPosIn);
            return this.renderEnv;
        }
        this.renderEnv.reset(blockStateIn, blockPosIn);
        return this.renderEnv;
    }

    private static void quadsToTriangles(ByteBuffer byteBuffer, VertexFormat vertexFormat, int vertexCount, ByteBuffer byteBufferTriangles) {
        int vertexSize = vertexFormat.m_86020_();
        int limit = byteBuffer.limit();
        byteBuffer.rewind();
        byteBufferTriangles.clear();
        for (int v = 0; v < vertexCount; v += 4) {
            byteBuffer.limit((v + 3) * vertexSize);
            byteBuffer.position(v * vertexSize);
            byteBufferTriangles.put(byteBuffer);
            byteBuffer.limit((v + 1) * vertexSize);
            byteBuffer.position(v * vertexSize);
            byteBufferTriangles.put(byteBuffer);
            byteBuffer.limit((v + 2 + 2) * vertexSize);
            byteBuffer.position((v + 2) * vertexSize);
            byteBufferTriangles.put(byteBuffer);
        }
        byteBuffer.limit(limit);
        byteBuffer.rewind();
        byteBufferTriangles.flip();
    }

    public VertexFormat.Mode getDrawMode() {
        return this.f_85657_;
    }

    public int getVertexCount() {
        return this.f_85654_;
    }

    public Vector3f getTempVec3f(Vector3f vec) {
        this.tempVec3f.m_122245_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
        return this.tempVec3f;
    }

    public Vector3f getTempVec3f(float x, float y, float z) {
        this.tempVec3f.m_122245_(x, y, z);
        return this.tempVec3f;
    }

    public float[] getTempFloat4(float f1, float f2, float f3, float f4) {
        this.tempFloat4[0] = f1;
        this.tempFloat4[1] = f2;
        this.tempFloat4[2] = f3;
        this.tempFloat4[3] = f4;
        return this.tempFloat4;
    }

    public int[] getTempInt4(int i1, int i2, int i3, int i4) {
        this.tempInt4[0] = i1;
        this.tempInt4[1] = i2;
        this.tempInt4[2] = i3;
        this.tempInt4[3] = i4;
        return this.tempInt4;
    }

    public ByteBuffer getByteBuffer() {
        return this.f_85648_;
    }

    public FloatBuffer getFloatBuffer() {
        return this.floatBuffer;
    }

    public IntBuffer getIntBuffer() {
        return this.intBuffer;
    }

    public int getBufferIntSize() {
        return this.f_85654_ * this.f_85658_.m_86017_();
    }

    private FloatBuffer getFloatBufferSort(int size) {
        if (this.floatBufferSort == null || this.floatBufferSort.capacity() < size) {
            this.floatBufferSort = BufferUtil.createDirectFloatBuffer((int)size);
        }
        return this.floatBufferSort;
    }

    public MultiBufferSource.BufferSource getRenderTypeBuffer() {
        return this.renderTypeBuffer;
    }

    public void setRenderTypeBuffer(MultiBufferSource.BufferSource renderTypeBuffer) {
        this.renderTypeBuffer = renderTypeBuffer;
    }

    public void addVertexText(float x, float y, float z, int red, int green, int blue, int alpha, float texU, float texV, int lightmapU, int lightmapV) {
        if (this.f_85658_.m_86020_() != DefaultVertexFormat.f_85820_.m_86020_()) {
            throw new IllegalStateException("Invalid text vertex format: " + this.f_85658_);
        }
        this.m_5832_(0, x);
        this.m_5832_(4, y);
        this.m_5832_(8, z);
        this.m_5672_(12, (byte)red);
        this.m_5672_(13, (byte)green);
        this.m_5672_(14, (byte)blue);
        this.m_5672_(15, (byte)alpha);
        this.m_5832_(16, texU);
        this.m_5832_(20, texV);
        this.m_5586_(24, (short)lightmapU);
        this.m_5586_(26, (short)lightmapV);
        this.f_85652_ += this.f_85658_.m_86020_();
        this.m_5752_();
    }

    public void setQuadVertexPositions(VertexPosition[] vps) {
        this.quadVertexPositions = vps;
    }

    public VertexPosition[] getQuadVertexPositions() {
        return this.quadVertexPositions;
    }

    public void setMidBlock(float mx, float my, float mz) {
        this.midBlock.m_122245_(mx, my, mz);
    }

    public Vector3f getMidBlock() {
        return this.midBlock;
    }

    public void putBulkData(ByteBuffer buffer) {
        if (Config.isShaders()) {
            SVertexBuilder.beginAddVertexData((BufferBuilder)this, (ByteBuffer)buffer);
        }
        this.m_85722_(buffer.limit() + this.f_85658_.m_86020_());
        this.f_85648_.position(this.f_85654_ * this.f_85658_.m_86020_());
        this.f_85648_.put(buffer);
        this.f_85654_ += buffer.limit() / this.f_85658_.m_86020_();
        this.f_85652_ += buffer.limit();
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertexData((BufferBuilder)this);
        }
    }

    public VertexFormat getVertexFormat() {
        return this.f_85658_;
    }

    public int getStartPosition() {
        return this.f_85651_;
    }

    public int getIntStartPosition() {
        return this.f_85651_ / 4;
    }
}

