/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.authlib.minecraft.TelemetryEvent;
import com.mojang.authlib.minecraft.TelemetryPropertyContainer;
import com.mojang.authlib.minecraft.TelemetrySession;
import com.mojang.authlib.minecraft.UserApiService;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.WorldVersion;
import net.minecraft.client.ClientTelemetryManager;
import net.minecraft.client.Minecraft;
import net.minecraft.util.TelemetryConstants;
import net.minecraft.world.level.GameType;
import net.optifine.Config;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientTelemetryManager {
    private static final AtomicInteger f_193530_ = new AtomicInteger(1);
    private static final Executor f_193531_ = Executors.newSingleThreadExecutor(p_193559_0_ -> {
        Thread thread = new Thread(p_193559_0_);
        thread.setName("Telemetry-Sender-#" + f_193530_.getAndIncrement());
        return thread;
    });
    private final Minecraft f_193532_;
    private final TelemetrySession f_193533_;
    private boolean f_193534_;
    @Nullable
    private PlayerInfo f_193535_;
    @Nullable
    private String f_193536_;

    public ClientTelemetryManager(Minecraft p_i193538_1_, UserApiService p_i193538_2_, Optional<String> p_i193538_3_, Optional<String> p_i193538_4_, UUID p_i193538_5_) {
        this.f_193532_ = p_i193538_1_;
        if (!SharedConstants.f_136183_ && Config.isTelemetryOn()) {
            if (Config.isTelemetryAnonymous()) {
                p_i193538_3_ = Optional.empty();
                p_i193538_4_ = Optional.empty();
                p_i193538_5_ = new UUID(0L, 0L);
            }
            this.f_193533_ = p_i193538_2_.newTelemetrySession(f_193531_);
            TelemetryPropertyContainer telemetrypropertycontainer = this.f_193533_.globalProperties();
            ClientTelemetryManager.m_193563_((String)"UserId", p_i193538_3_, (TelemetryPropertyContainer)telemetrypropertycontainer);
            ClientTelemetryManager.m_193563_((String)"ClientId", p_i193538_4_, (TelemetryPropertyContainer)telemetrypropertycontainer);
            telemetrypropertycontainer.addProperty("deviceSessionId", p_i193538_5_.toString());
            telemetrypropertycontainer.addProperty("WorldSessionId", UUID.randomUUID().toString());
            this.f_193533_.eventSetupFunction(p_193548_0_ -> p_193548_0_.addProperty("eventTimestampUtc", TelemetryConstants.f_184761_.format(Instant.now())));
        } else {
            this.f_193533_ = TelemetrySession.DISABLED;
        }
    }

    private static void m_193563_(String p_193563_0_, Optional<String> p_193563_1_, TelemetryPropertyContainer p_193563_2_) {
        p_193563_1_.ifPresentOrElse(p_193553_2_ -> p_193563_2_.addProperty(p_193563_0_, p_193553_2_), () -> p_193563_2_.addNullProperty(p_193563_0_));
    }

    public void m_193545_(GameType p_193545_1_, boolean p_193545_2_) {
        this.f_193535_ = new PlayerInfo(p_193545_1_, p_193545_2_);
        if (this.f_193536_ != null) {
            this.m_193557_(this.f_193535_);
        }
    }

    public void m_193561_(String p_193561_1_) {
        this.f_193536_ = p_193561_1_;
        if (this.f_193535_ != null) {
            this.m_193557_(this.f_193535_);
        }
    }

    private void m_193557_(PlayerInfo p_193557_1_) {
        if (!this.f_193534_) {
            this.f_193534_ = true;
            if (this.f_193533_.isEnabled()) {
                TelemetryEvent telemetryevent = this.f_193533_.createNewEvent("WorldLoaded");
                WorldVersion worldversion = SharedConstants.m_183709_();
                telemetryevent.addProperty("build_display_name", worldversion.getId());
                telemetryevent.addProperty("clientModded", Minecraft.m_193589_().m_184597_());
                if (this.f_193536_ != null) {
                    telemetryevent.addProperty("serverModded", !this.f_193536_.equals("vanilla"));
                } else {
                    telemetryevent.addNullProperty("serverModded");
                }
                telemetryevent.addProperty("server_type", this.m_193567_());
                telemetryevent.addProperty("BuildPlat", Util.m_137581_().m_183999_());
                telemetryevent.addProperty("Plat", System.getProperty("os.name"));
                telemetryevent.addProperty("javaVersion", System.getProperty("java.version"));
                telemetryevent.addProperty("PlayerGameMode", p_193557_1_.m_193575_());
                telemetryevent.send();
            }
        }
    }

    private String m_193567_() {
        if (this.f_193532_.m_91294_()) {
            return "realm";
        }
        return this.f_193532_.m_91091_() ? "local" : "server";
    }

    public void m_193544_() {
        if (this.f_193535_ != null) {
            this.m_193557_(this.f_193535_);
        }
    }
}

