/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.ClipboardManager;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.Option;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SimpleOptionsSubScreen;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.client.gui.screens.debug.GameModeSwitcherScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.gui.GuiShaderOptions;

public class KeyboardHandler {
    public static final int f_167812_ = 10000;
    private final Minecraft f_90867_;
    private boolean f_90868_;
    private final ClipboardManager f_90869_ = new ClipboardManager();
    private long f_90870_ = -1L;
    private long f_90871_ = -1L;
    private long f_90872_ = -1L;
    private boolean f_90873_;
    private static boolean chunkDebugKeys = Boolean.getBoolean("chunk.debug.keys");

    public KeyboardHandler(Minecraft mcIn) {
        this.f_90867_ = mcIn;
    }

    private boolean m_167813_(int keyIn) {
        switch (keyIn) {
            case 69: {
                this.f_90867_.f_90978_ = !this.f_90867_.f_90978_;
                this.m_167837_("ChunkPath: {0}", new Object[]{this.f_90867_.f_90978_ ? "shown" : "hidden"});
                return true;
            }
            case 76: {
                this.f_90867_.f_90980_ = !this.f_90867_.f_90980_;
                this.m_167837_("SmartCull: {0}", new Object[]{this.f_90867_.f_90980_ ? "enabled" : "disabled"});
                return true;
            }
            case 85: {
                if (Screen.m_96638_()) {
                    this.f_90867_.f_91060_.m_173019_();
                    this.m_167837_("Killed frustum", new Object[0]);
                } else if (Screen.m_96639_()) {
                    if (Config.isShadersShadows()) {
                        this.f_90867_.f_91060_.captureFrustumShadow();
                        this.m_167837_("Captured shadow frustum", new Object[0]);
                    }
                } else {
                    this.f_90867_.f_91060_.m_173018_();
                    this.m_167837_("Captured frustum", new Object[0]);
                }
                return true;
            }
            case 86: {
                this.f_90867_.f_90979_ = !this.f_90867_.f_90979_;
                this.m_167837_("ChunkVisibility: {0}", new Object[]{this.f_90867_.f_90979_ ? "enabled" : "disabled"});
                return true;
            }
            case 87: {
                this.f_90867_.f_167842_ = !this.f_90867_.f_167842_;
                this.m_167837_("WireFrame: {0}", new Object[]{this.f_90867_.f_167842_ ? "enabled" : "disabled"});
                return true;
            }
        }
        return false;
    }

    private void m_167824_(ChatFormatting formatIn, Component componentIn) {
        this.f_90867_.f_91065_.m_93076_().m_93785_((Component)new TextComponent("").m_7220_((Component)new TranslatableComponent("debug.prefix").m_130944_(new ChatFormatting[]{formatIn, ChatFormatting.BOLD})).m_130946_(" ").m_7220_(componentIn));
    }

    private void m_167822_(Component componentIn) {
        this.m_167824_(ChatFormatting.YELLOW, componentIn);
    }

    private void m_90913_(String message, Object ... args) {
        this.m_167822_((Component)new TranslatableComponent(message, args));
    }

    private void m_90948_(String message, Object ... args) {
        this.m_167824_(ChatFormatting.RED, (Component)new TranslatableComponent(message, args));
    }

    private void m_167837_(String message, Object ... params) {
        this.m_167822_((Component)new TextComponent(MessageFormat.format(message, params)));
    }

    private boolean m_90932_(int key) {
        if (this.f_90870_ > 0L && this.f_90870_ < Util.m_137550_() - 100L) {
            return true;
        }
        if (chunkDebugKeys && this.m_167813_(key)) {
            return true;
        }
        switch (key) {
            case 65: {
                this.f_90867_.f_91060_.m_109818_();
                this.m_90913_("debug.reload_chunks.message", new Object[0]);
                return true;
            }
            case 66: {
                boolean flag = !this.f_90867_.m_91290_().m_114377_();
                this.f_90867_.m_91290_().m_114473_(flag);
                this.m_90913_(flag ? "debug.show_hitboxes.on" : "debug.show_hitboxes.off", new Object[0]);
                return true;
            }
            case 67: {
                if (this.f_90867_.f_91074_.m_36330_()) {
                    return false;
                }
                ClientPacketListener clientpacketlistener = this.f_90867_.f_91074_.f_108617_;
                if (clientpacketlistener == null) {
                    return false;
                }
                this.m_90913_("debug.copy_location.message", new Object[0]);
                this.m_90911_(String.format(Locale.ROOT, "/execute in %s run tp @s %.2f %.2f %.2f %.2f %.2f", this.f_90867_.f_91074_.f_19853_.m_46472_().m_135782_(), this.f_90867_.f_91074_.m_20185_(), this.f_90867_.f_91074_.m_20186_(), this.f_90867_.f_91074_.m_20189_(), Float.valueOf(this.f_90867_.f_91074_.m_146908_()), Float.valueOf(this.f_90867_.f_91074_.m_146909_())));
                return true;
            }
            case 68: {
                if (this.f_90867_.f_91065_ != null) {
                    this.f_90867_.f_91065_.m_93076_().m_93795_(false);
                }
                return true;
            }
            case 70: {
                Option.f_91675_.m_92223_(this.f_90867_.f_91066_, Mth.m_14008_((double)(this.f_90867_.f_91066_.f_92106_ + (Screen.m_96638_() ? -1 : 1)), (double)Option.f_91675_.m_92232_(), (double)Option.f_91675_.m_92235_()));
                this.m_90913_("debug.cycle_renderdistance.message", new Object[]{this.f_90867_.f_91066_.f_92106_});
                return true;
            }
            case 71: {
                boolean flag1 = this.f_90867_.f_91064_.m_113506_();
                this.m_90913_(flag1 ? "debug.chunk_boundaries.on" : "debug.chunk_boundaries.off", new Object[0]);
                return true;
            }
            case 72: {
                this.f_90867_.f_91066_.f_92125_ = !this.f_90867_.f_91066_.f_92125_;
                this.m_90913_(this.f_90867_.f_91066_.f_92125_ ? "debug.advanced_tooltips.on" : "debug.advanced_tooltips.off", new Object[0]);
                this.f_90867_.f_91066_.m_92169_();
                return true;
            }
            case 73: {
                if (!this.f_90867_.f_91074_.m_36330_()) {
                    this.m_90928_(this.f_90867_.f_91074_.m_20310_(2), !Screen.m_96638_());
                }
                return true;
            }
            case 76: {
                if (this.f_90867_.m_167946_(arg_0 -> this.m_167822_(arg_0))) {
                    this.m_90913_("debug.profiling.start", new Object[]{10});
                }
                return true;
            }
            case 78: {
                if (!this.f_90867_.f_91074_.m_20310_(2)) {
                    this.m_90913_("debug.creative_spectator.error", new Object[0]);
                } else if (!this.f_90867_.f_91074_.m_5833_()) {
                    this.f_90867_.f_91074_.m_108739_("/gamemode spectator");
                } else {
                    this.f_90867_.f_91074_.m_108739_("/gamemode " + ((GameType)MoreObjects.firstNonNull((Object)this.f_90867_.f_91072_.m_105294_(), (Object)GameType.CREATIVE)).m_46405_());
                }
                return true;
            }
            case 80: {
                this.f_90867_.f_91066_.f_92126_ = !this.f_90867_.f_91066_.f_92126_;
                this.f_90867_.f_91066_.m_92169_();
                this.m_90913_(this.f_90867_.f_91066_.f_92126_ ? "debug.pause_focus.on" : "debug.pause_focus.off", new Object[0]);
                return true;
            }
            case 81: {
                this.m_90913_("debug.help.message", new Object[0]);
                ChatComponent chatcomponent = this.f_90867_.f_91065_.m_93076_();
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.reload_chunks.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.show_hitboxes.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.copy_location.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.clear_chat.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.cycle_renderdistance.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.chunk_boundaries.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.advanced_tooltips.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.inspect.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.profiling.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.creative_spectator.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.pause_focus.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.help.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.reload_resourcepacks.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.pause.help"));
                chatcomponent.m_93785_((Component)new TranslatableComponent("debug.gamemodes.help"));
                return true;
            }
            case 84: {
                this.m_90913_("debug.reload_resourcepacks.message", new Object[0]);
                this.f_90867_.m_91391_();
                return true;
            }
            case 293: {
                if (!this.f_90867_.f_91074_.m_20310_(2)) {
                    this.m_90913_("debug.gamemodes.error", new Object[0]);
                } else {
                    this.f_90867_.m_91152_((Screen)new GameModeSwitcherScreen());
                }
                return true;
            }
            default: {
                return false;
            }
            case 86: {
                Minecraft mc = Config.getMinecraft();
                mc.f_91060_.loadVisibleChunksCounter = 1;
                TextComponent msg = new TextComponent(I18n.m_118938_((String)"of.message.loadingVisibleChunks", (Object[])new Object[0]));
                mc.f_91065_.m_93076_().m_93787_((Component)msg, 201435902);
                return true;
            }
            case 79: {
                if (Config.isShaders()) {
                    GuiShaderOptions gui = new GuiShaderOptions(null, Config.getGameSettings());
                    Config.getMinecraft().m_91152_((Screen)gui);
                }
                return true;
            }
            case 82: 
        }
        if (Config.isShaders()) {
            Shaders.uninit();
            Shaders.loadShaderPack();
        }
        return true;
    }

    private void m_90928_(boolean privileged, boolean askServer) {
        HitResult hitresult = this.f_90867_.f_91077_;
        if (hitresult != null) {
            switch (1.$SwitchMap$net$minecraft$world$phys$HitResult$Type[hitresult.m_6662_().ordinal()]) {
                case 1: {
                    BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
                    BlockState blockstate = this.f_90867_.f_91074_.f_19853_.m_8055_(blockpos);
                    if (privileged) {
                        if (askServer) {
                            this.f_90867_.f_91074_.f_108617_.m_105149_().m_90708_(blockpos, p_90944_3_ -> {
                                this.m_90899_(blockstate, blockpos, p_90944_3_);
                                this.m_90913_("debug.inspect.server.block", new Object[0]);
                            });
                            break;
                        }
                        BlockEntity blockentity = this.f_90867_.f_91074_.f_19853_.m_7702_(blockpos);
                        CompoundTag compoundtag1 = blockentity != null ? blockentity.m_187482_() : null;
                        this.m_90899_(blockstate, blockpos, compoundtag1);
                        this.m_90913_("debug.inspect.client.block", new Object[0]);
                        break;
                    }
                    this.m_90899_(blockstate, blockpos, (CompoundTag)null);
                    this.m_90913_("debug.inspect.client.block", new Object[0]);
                    break;
                }
                case 2: {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    ResourceLocation resourcelocation = Registry.f_122826_.m_7981_((Object)entity.m_6095_());
                    if (privileged) {
                        if (askServer) {
                            this.f_90867_.f_91074_.f_108617_.m_105149_().m_90702_(entity.m_142049_(), p_90918_3_ -> {
                                this.m_90922_(resourcelocation, entity.m_20182_(), p_90918_3_);
                                this.m_90913_("debug.inspect.server.entity", new Object[0]);
                            });
                            break;
                        }
                        CompoundTag compoundtag = entity.m_20240_(new CompoundTag());
                        this.m_90922_(resourcelocation, entity.m_20182_(), compoundtag);
                        this.m_90913_("debug.inspect.client.entity", new Object[0]);
                        break;
                    }
                    this.m_90922_(resourcelocation, entity.m_20182_(), (CompoundTag)null);
                    this.m_90913_("debug.inspect.client.entity", new Object[0]);
                }
            }
        }
    }

    private void m_90899_(BlockState state, BlockPos pos, @Nullable CompoundTag compound) {
        StringBuilder stringbuilder = new StringBuilder(BlockStateParser.m_116769_((BlockState)state));
        if (compound != null) {
            stringbuilder.append(compound);
        }
        String s = String.format(Locale.ROOT, "/setblock %d %d %d %s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stringbuilder);
        this.m_90911_(s);
    }

    private void m_90922_(ResourceLocation entityIdIn, Vec3 pos, @Nullable CompoundTag compound) {
        String s;
        if (compound != null) {
            compound.m_128473_("UUID");
            compound.m_128473_("Pos");
            compound.m_128473_("Dimension");
            String s1 = NbtUtils.m_178061_((Tag)compound).getString();
            s = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f %s", entityIdIn.toString(), pos.f_82479_, pos.f_82480_, pos.f_82481_, s1);
        } else {
            s = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f", entityIdIn.toString(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
        this.m_90911_(s);
    }

    public void m_90893_(long windowPointer, int key, int scanCode, int action, int modifiers) {
        if (windowPointer == this.f_90867_.m_91268_().m_85439_()) {
            if (this.f_90870_ > 0L) {
                if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)67) || !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292)) {
                    this.f_90870_ = -1L;
                }
            } else if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)67) && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292)) {
                this.f_90873_ = true;
                this.f_90870_ = Util.m_137550_();
                this.f_90871_ = Util.m_137550_();
                this.f_90872_ = 0L;
            }
            Screen screen = this.f_90867_.f_91080_;
            if (!(this.f_90867_.f_91080_ instanceof KeyBindsScreen) || ((KeyBindsScreen)screen).f_193976_ <= Util.m_137550_() - 20L) {
                if (action == 1) {
                    if (this.f_90867_.f_91066_.f_92105_.m_90832_(key, scanCode)) {
                        this.f_90867_.m_91268_().m_85438_();
                        this.f_90867_.f_91066_.f_92052_ = this.f_90867_.m_91268_().m_85440_();
                        this.f_90867_.f_91066_.m_92169_();
                        return;
                    }
                    if (this.f_90867_.f_91066_.f_92102_.m_90832_(key, scanCode)) {
                        if (Screen.m_96637_()) {
                            // empty if block
                        }
                        Screenshot.m_92289_((File)this.f_90867_.f_91069_, (RenderTarget)this.f_90867_.m_91385_(), p_90916_1_ -> this.f_90867_.execute(() -> this.f_90867_.f_91065_.m_93076_().m_93785_(p_90916_1_)));
                        return;
                    }
                } else if (action == 0 && this.f_90867_.f_91080_ instanceof KeyBindsScreen) {
                    ((KeyBindsScreen)this.f_90867_.f_91080_).f_193975_ = null;
                }
            }
            if (NarratorChatListener.f_93311_.m_93316_()) {
                boolean flag;
                boolean bl = flag = screen == null || !(screen.m_7222_() instanceof EditBox) || !((EditBox)screen.m_7222_()).m_94204_();
                if (action != 0 && key == 66 && Screen.m_96637_() && flag) {
                    boolean flag1 = this.f_90867_.f_91066_.f_92074_ == NarratorStatus.OFF;
                    this.f_90867_.f_91066_.f_92074_ = NarratorStatus.m_91619_((int)(this.f_90867_.f_91066_.f_92074_.m_91618_() + 1));
                    NarratorChatListener.f_93311_.m_93317_(this.f_90867_.f_91066_.f_92074_);
                    if (screen instanceof SimpleOptionsSubScreen) {
                        ((SimpleOptionsSubScreen)screen).m_96682_();
                    }
                    if (flag1 && screen != null) {
                        screen.m_169418_();
                    }
                }
            }
            if (screen != null) {
                boolean[] aboolean = new boolean[]{false};
                Screen.m_96579_(() -> {
                    if (!(action == 1 || action == 2 && this.f_90868_)) {
                        if (action == 0) {
                            if (Reflector.ForgeHooksClient_onScreenKeyReleasedPre.exists()) {
                                aboolean[0] = Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenKeyReleasedPre, (Object[])new Object[]{screen, key, scanCode, modifiers});
                                if (aboolean[0]) {
                                    return;
                                }
                            }
                            aboolean[0] = screen.m_7920_(key, scanCode, modifiers);
                            if (Reflector.ForgeHooksClient_onScreenKeyReleasedPost.exists() && !aboolean[0]) {
                                aboolean[0] = Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenKeyReleasedPost, (Object[])new Object[]{screen, key, scanCode, modifiers});
                            }
                        }
                    } else {
                        if (Reflector.ForgeHooksClient_onScreenKeyPressedPre.exists()) {
                            aboolean[0] = Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenKeyPressedPre, (Object[])new Object[]{screen, key, scanCode, modifiers});
                            if (aboolean[0]) {
                                return;
                            }
                        }
                        screen.m_169416_();
                        aboolean[0] = screen.m_7933_(key, scanCode, modifiers);
                        if (Reflector.ForgeHooksClient_onScreenKeyPressedPost.exists() && !aboolean[0]) {
                            aboolean[0] = Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenKeyPressedPost, (Object[])new Object[]{screen, key, scanCode, modifiers});
                        }
                    }
                }, (String)"keyPressed event handler", (String)screen.getClass().getCanonicalName());
                if (aboolean[0]) {
                    return;
                }
            }
            if (this.f_90867_.f_91080_ == null || this.f_90867_.f_91080_.f_96546_) {
                InputConstants.Key inputconstants$key = InputConstants.m_84827_((int)key, (int)scanCode);
                if (action == 0) {
                    KeyMapping.m_90837_((InputConstants.Key)inputconstants$key, (boolean)false);
                    if (key == 292) {
                        if (this.f_90873_) {
                            this.f_90873_ = false;
                        } else {
                            this.f_90867_.f_91066_.f_92063_ = !this.f_90867_.f_91066_.f_92063_;
                            this.f_90867_.f_91066_.f_92064_ = this.f_90867_.f_91066_.f_92063_ && Screen.m_96638_();
                            boolean bl = this.f_90867_.f_91066_.f_92065_ = this.f_90867_.f_91066_.f_92063_ && Screen.m_96639_();
                            if (this.f_90867_.f_91066_.f_92063_) {
                                if (this.f_90867_.f_91066_.ofLagometer) {
                                    this.f_90867_.f_91066_.f_92065_ = true;
                                }
                                if (this.f_90867_.f_91066_.ofProfiler) {
                                    this.f_90867_.f_91066_.f_92064_ = true;
                                }
                            }
                        }
                    }
                } else {
                    if (key == 293 && this.f_90867_.f_91063_ != null) {
                        this.f_90867_.f_91063_.m_109130_();
                    }
                    boolean flag3 = false;
                    if (this.f_90867_.f_91080_ == null) {
                        if (key == 256) {
                            boolean flag2 = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292);
                            this.f_90867_.m_91358_(flag2);
                        }
                        flag3 = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292) && this.m_90932_(key);
                        this.f_90873_ |= flag3;
                        if (key == 290) {
                            boolean bl = this.f_90867_.f_91066_.f_92062_ = !this.f_90867_.f_91066_.f_92062_;
                        }
                    }
                    if (flag3) {
                        KeyMapping.m_90837_((InputConstants.Key)inputconstants$key, (boolean)false);
                    } else {
                        KeyMapping.m_90837_((InputConstants.Key)inputconstants$key, (boolean)true);
                        KeyMapping.m_90835_((InputConstants.Key)inputconstants$key);
                    }
                    if (this.f_90867_.f_91066_.f_92064_ && key >= 48 && key <= 57) {
                        this.f_90867_.m_91111_(key - 48);
                    }
                }
            }
            Reflector.ForgeHooksClient_fireKeyInput.call(new Object[]{key, scanCode, action, modifiers});
        }
    }

    private void m_90889_(long windowPointer, int codePoint, int modifiers) {
        Screen guieventlistener;
        if (windowPointer == this.f_90867_.m_91268_().m_85439_() && (guieventlistener = this.f_90867_.f_91080_) != null && this.f_90867_.m_91265_() == null) {
            if (Character.charCount(codePoint) == 1) {
                Screen.m_96579_(() -> {
                    if (Reflector.ForgeHooksClient_onScreenCharTypedPre.exists() && Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenCharTypedPre, (Object[])new Object[]{guieventlistener, Character.valueOf((char)codePoint), modifiers})) {
                        return;
                    }
                    boolean consumed = guieventlistener.m_5534_((char)codePoint, modifiers);
                    if (Reflector.ForgeHooksClient_onScreenCharTypedPost.exists() && !consumed) {
                        Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenCharTypedPost, (Object[])new Object[]{guieventlistener, Character.valueOf((char)codePoint), modifiers});
                    }
                }, (String)"charTyped event handler", (String)guieventlistener.getClass().getCanonicalName());
            } else {
                for (char c0 : Character.toChars(codePoint)) {
                    Screen.m_96579_(() -> {
                        if (Reflector.ForgeHooksClient_onScreenCharTypedPre.exists() && Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenCharTypedPre, (Object[])new Object[]{guieventlistener, Character.valueOf(c0), modifiers})) {
                            return;
                        }
                        boolean consumed = guieventlistener.m_5534_(c0, modifiers);
                        if (Reflector.ForgeHooksClient_onScreenCharTypedPost.exists() && !consumed) {
                            Reflector.callBoolean((ReflectorMethod)Reflector.ForgeHooksClient_onScreenCharTypedPost, (Object[])new Object[]{guieventlistener, Character.valueOf(c0), modifiers});
                        }
                    }, (String)"charTyped event handler", (String)guieventlistener.getClass().getCanonicalName());
                }
            }
        }
    }

    public void m_90926_(boolean valueIn) {
        this.f_90868_ = valueIn;
    }

    public void m_90887_(long window) {
        InputConstants.m_84844_((long)window, (p_90938_1_, p_90938_3_, p_90938_4_, p_90938_5_, p_90938_6_) -> this.f_90867_.execute(() -> this.m_90893_(p_90938_1_, p_90938_3_, p_90938_4_, p_90938_5_, p_90938_6_)), (p_90934_1_, p_90934_3_, p_90934_4_) -> this.f_90867_.execute(() -> this.m_90889_(p_90934_1_, p_90934_3_, p_90934_4_)));
    }

    public String m_90876_() {
        return this.f_90869_.m_83995_(this.f_90867_.m_91268_().m_85439_(), (p_90877_1_, p_90877_2_) -> {
            if (p_90877_1_ != 65545) {
                this.f_90867_.m_91268_().m_85382_(p_90877_1_, p_90877_2_);
            }
        });
    }

    public void m_90911_(String string) {
        if (!string.isEmpty()) {
            this.f_90869_.m_83988_(this.f_90867_.m_91268_().m_85439_(), string);
        }
    }

    public void m_90931_() {
        if (this.f_90870_ > 0L) {
            long i2 = Util.m_137550_();
            long j2 = 10000L - (i2 - this.f_90870_);
            long k2 = i2 - this.f_90871_;
            if (j2 < 0L) {
                if (Screen.m_96637_()) {
                    Blaze3D.m_83639_();
                }
                String s = "Manually triggered debug crash";
                CrashReport crashreport = new CrashReport("Manually triggered debug crash", new Throwable("Manually triggered debug crash"));
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Manual crash details");
                NativeModuleLister.m_184679_((CrashReportCategory)crashreportcategory);
                throw new ReportedException(crashreport);
            }
            if (k2 >= 1000L) {
                if (this.f_90872_ == 0L) {
                    this.m_90913_("debug.crash.message", new Object[0]);
                } else {
                    this.m_90948_("debug.crash.warning", new Object[]{Mth.m_14167_((float)((float)j2 / 1000.0f))});
                }
                this.f_90871_ = i2;
                ++this.f_90872_;
            }
        }
    }
}

