/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.SliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.optifine.Config;

public class ProgressOption
extends Option {
    protected final float f_92204_;
    protected final double f_92205_;
    protected double f_92206_;
    private final Function<Minecraft, List<FormattedCharSequence>> f_168538_;
    protected Function<Options, Double> f_92207_;
    protected BiConsumer<Options, Double> f_92208_;
    protected BiFunction<Options, ProgressOption, Component> f_92209_;
    protected double[] stepValues;

    public ProgressOption(String p_i168539_1_, double p_i168539_2_, double p_i168539_4_, float p_i168539_6_, Function<Options, Double> p_i168539_7_, BiConsumer<Options, Double> p_i168539_8_, BiFunction<Options, ProgressOption, Component> p_i168539_9_, Function<Minecraft, List<FormattedCharSequence>> p_i168539_10_) {
        super(p_i168539_1_);
        this.f_92205_ = p_i168539_2_;
        this.f_92206_ = p_i168539_4_;
        this.f_92204_ = p_i168539_6_;
        this.f_92207_ = p_i168539_7_;
        this.f_92208_ = p_i168539_8_;
        this.f_92209_ = p_i168539_9_;
        this.f_168538_ = p_i168539_10_;
    }

    public ProgressOption(String translationKey, double minValueIn, double maxValueIn, float stepSizeIn, Function<Options, Double> getter, BiConsumer<Options, Double> setter, BiFunction<Options, ProgressOption, Component> getDisplayString) {
        this(translationKey, minValueIn, maxValueIn, stepSizeIn, getter, setter, getDisplayString, p_168548_0_ -> ImmutableList.of());
    }

    public ProgressOption(String translationKey, double minValueIn, double maxValueIn, double[] stepValues, Function<Options, Double> getter, BiConsumer<Options, Double> setter, BiFunction<Options, ProgressOption, Component> getDisplayString) {
        super(translationKey);
        this.f_92205_ = minValueIn;
        this.f_92206_ = maxValueIn;
        this.f_92204_ = 0.0f;
        this.f_92207_ = getter;
        this.f_92208_ = setter;
        this.f_92209_ = getDisplayString;
        this.f_168538_ = x -> new ArrayList();
        this.stepValues = stepValues;
        if (stepValues != null) {
            stepValues = (double[])stepValues.clone();
            Arrays.sort(stepValues);
        }
    }

    public AbstractWidget m_7496_(Options options, int xIn, int yIn, int widthIn) {
        List list = (List)this.f_168538_.apply(Minecraft.m_91087_());
        return new SliderButton(options, xIn, yIn, widthIn, 20, this, list);
    }

    public double m_6917_(double value) {
        return Mth.m_14008_((double)((this.m_92236_(value) - this.f_92205_) / (this.f_92206_ - this.f_92205_)), (double)0.0, (double)1.0);
    }

    public double m_6912_(double value) {
        return this.m_92236_(Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)this.f_92205_, (double)this.f_92206_));
    }

    private double m_92236_(double valueIn) {
        if (this.f_92204_ > 0.0f) {
            valueIn = this.f_92204_ * (float)Math.round(valueIn / (double)this.f_92204_);
        }
        if (this.stepValues != null) {
            for (int i2 = 0; i2 < this.stepValues.length; ++i2) {
                double max;
                double min = i2 <= 0 ? -1.7976931348623157E308 : (this.stepValues[i2 - 1] + this.stepValues[i2]) / 2.0;
                double d2 = max = i2 >= this.stepValues.length - 1 ? Double.MAX_VALUE : (this.stepValues[i2] + this.stepValues[i2 + 1]) / 2.0;
                if (!Config.between((double)valueIn, (double)min, (double)max)) continue;
                valueIn = this.stepValues[i2];
                break;
            }
        }
        return Mth.m_14008_((double)valueIn, (double)this.f_92205_, (double)this.f_92206_);
    }

    public double m_92232_() {
        return this.f_92205_;
    }

    public double m_92235_() {
        return this.f_92206_;
    }

    public void m_92219_(float valueIn) {
        this.f_92206_ = valueIn;
    }

    public void m_92223_(Options options, double valueIn) {
        this.f_92208_.accept(options, valueIn);
    }

    public double m_92221_(Options options) {
        return (Double)this.f_92207_.apply(options);
    }

    public Component m_92233_(Options options) {
        return (Component)this.f_92209_.apply(options, this);
    }
}

