/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;

public class BossHealthOverlay
extends GuiComponent {
    private static final ResourceLocation f_93697_ = new ResourceLocation("textures/gui/bars.png");
    private static final int f_168805_ = 182;
    private static final int f_168806_ = 5;
    private static final int f_168807_ = 80;
    private final Minecraft f_93698_;
    final Map<UUID, LerpingBossEvent> f_93699_ = Maps.newLinkedHashMap();

    public BossHealthOverlay(Minecraft clientIn) {
        this.f_93698_ = clientIn;
    }

    public void m_93704_(PoseStack matrixStackIn) {
        if (!this.f_93699_.isEmpty()) {
            int i2 = this.f_93698_.m_91268_().m_85445_();
            int j2 = 12;
            for (LerpingBossEvent lerpingbossevent : this.f_93699_.values()) {
                int k2 = i2 / 2 - 91;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean render = true;
                int increment = 19;
                if (Reflector.ForgeHooksClient_renderBossEventPre.exists()) {
                    Object[] objectArray = new Object[6];
                    objectArray[0] = matrixStackIn;
                    objectArray[1] = this.f_93698_.m_91268_();
                    objectArray[2] = lerpingbossevent;
                    objectArray[3] = k2;
                    objectArray[4] = j2;
                    Objects.requireNonNull(this.f_93698_.f_91062_);
                    objectArray[5] = 10 + 9;
                    Object event = Reflector.ForgeHooksClient_renderBossEventPre.call(objectArray);
                    render = !Reflector.callBoolean((Object)event, (ReflectorMethod)Reflector.Event_isCanceled, (Object[])new Object[0]);
                    increment = Reflector.callInt((Object)event, (ReflectorMethod)Reflector.RenderGameOverlayEvent_BossInfo_getIncrement, (Object[])new Object[0]);
                }
                if (render) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)f_93697_);
                    this.m_93706_(matrixStackIn, k2, j2, (BossEvent)lerpingbossevent);
                    Component component = lerpingbossevent.m_18861_();
                    int l2 = this.f_93698_.f_91062_.m_92852_((FormattedText)component);
                    int i1 = i2 / 2 - l2 / 2;
                    int j1 = j2 - 9;
                    int col = 0xFFFFFF;
                    if (Config.isCustomColors()) {
                        col = CustomColors.getBossTextColor((int)col);
                    }
                    this.f_93698_.f_91062_.m_92763_(matrixStackIn, component, (float)i1, (float)j1, col);
                }
                Reflector.ForgeHooksClient_renderBossEventPost.callVoid(new Object[]{matrixStackIn, this.f_93698_.m_91268_()});
                if ((j2 += increment) < this.f_93698_.m_91268_().m_85446_() / 3) continue;
                break;
            }
        }
    }

    private void m_93706_(PoseStack matrixStackIn, int xIn, int yIn, BossEvent eventIn) {
        int i2;
        this.m_93228_(matrixStackIn, xIn, yIn, 0, eventIn.m_18862_().ordinal() * 5 * 2, 182, 5);
        if (eventIn.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            this.m_93228_(matrixStackIn, xIn, yIn, 0, 80 + (eventIn.m_18863_().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i2 = (int)(eventIn.m_142717_() * 183.0f)) > 0) {
            this.m_93228_(matrixStackIn, xIn, yIn, 0, eventIn.m_18862_().ordinal() * 5 * 2 + 5, i2, 5);
            if (eventIn.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
                this.m_93228_(matrixStackIn, xIn, yIn, 0, 80 + (eventIn.m_18863_().ordinal() - 1) * 5 * 2 + 5, i2, 5);
            }
        }
    }

    public void m_93711_(ClientboundBossEventPacket packetIn) {
        packetIn.m_178643_((ClientboundBossEventPacket.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void m_93703_() {
        this.f_93699_.clear();
    }

    public boolean m_93713_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                if (!bossevent.m_18865_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93714_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                if (!bossevent.m_18864_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93715_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                if (!bossevent.m_18866_()) continue;
                return true;
            }
        }
        return false;
    }

    public String getBossName() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                Component name = bossevent.m_18861_();
                if (!(name instanceof TranslatableComponent)) continue;
                TranslatableComponent nameTran = (TranslatableComponent)name;
                return nameTran.m_131328_();
            }
        }
        return null;
    }
}

