/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.FontTexture;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.gui.font.glyphs.MissingGlyph;
import net.minecraft.client.gui.font.glyphs.WhiteGlyph;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class FontSet
implements AutoCloseable {
    private static final EmptyGlyph f_95048_ = new EmptyGlyph();
    private static final GlyphInfo f_95049_ = () -> 4.0f;
    private static final GlyphInfo f_202355_ = () -> 0.0f;
    private static final int f_202356_ = 8204;
    private static final Random f_95050_ = new Random();
    private final TextureManager f_95051_;
    private final ResourceLocation f_95052_;
    private BakedGlyph f_95053_;
    private BakedGlyph f_95054_;
    private final List<GlyphProvider> f_95055_ = Lists.newArrayList();
    private final Int2ObjectMap<BakedGlyph> f_95056_ = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<GlyphInfo> f_95057_ = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<IntList> f_95058_ = new Int2ObjectOpenHashMap();
    private final List<FontTexture> f_95059_ = Lists.newArrayList();

    public FontSet(TextureManager textureManagerIn, ResourceLocation resourceLocationIn) {
        this.f_95051_ = textureManagerIn;
        this.f_95052_ = resourceLocationIn;
    }

    public void m_95071_(List<GlyphProvider> glyphProvidersIn) {
        this.m_95077_();
        this.m_95080_();
        this.f_95056_.clear();
        this.f_95057_.clear();
        this.f_95058_.clear();
        this.f_95053_ = this.m_95069_((RawGlyph)MissingGlyph.INSTANCE);
        this.f_95054_ = this.m_95069_((RawGlyph)WhiteGlyph.INSTANCE);
        IntOpenHashSet intset = new IntOpenHashSet();
        for (GlyphProvider glyphprovider : glyphProvidersIn) {
            intset.addAll((IntCollection)glyphprovider.m_6990_());
        }
        HashSet set = Sets.newHashSet();
        intset.forEach(p_202357_3_ -> {
            for (GlyphProvider glyphprovider1 : glyphProvidersIn) {
                GlyphInfo glyphinfo = this.m_202361_(p_202357_3_);
                if (glyphinfo == null) {
                    glyphinfo = glyphprovider1.m_7823_(p_202357_3_);
                }
                if (glyphinfo == null) continue;
                set.add(glyphprovider1);
                if (glyphinfo == MissingGlyph.INSTANCE) break;
                ((IntList)this.f_95058_.computeIfAbsent(Mth.m_14167_((float)glyphinfo.m_83827_(false)), p_202368_0_ -> new IntArrayList())).add(p_202357_3_);
                break;
            }
        });
        glyphProvidersIn.stream().filter(set::contains).forEach(this.f_95055_::add);
    }

    @Override
    public void close() {
        this.m_95077_();
        this.m_95080_();
    }

    private void m_95077_() {
        for (GlyphProvider glyphprovider : this.f_95055_) {
            glyphprovider.close();
        }
        this.f_95055_.clear();
    }

    private void m_95080_() {
        for (FontTexture fonttexture : this.f_95059_) {
            fonttexture.close();
        }
        this.f_95059_.clear();
    }

    @Nullable
    private GlyphInfo m_202361_(int charIn) {
        return switch (charIn) {
            case 32 -> f_95049_;
            case 8204 -> f_202355_;
            default -> null;
        };
    }

    public GlyphInfo m_95065_(int charIn) {
        Object glyph = (GlyphInfo)this.f_95057_.get(charIn);
        if (glyph == null) {
            glyph = charIn == 32 ? f_95049_ : this.m_95081_(charIn);
            this.f_95057_.put(charIn, glyph);
        }
        return glyph;
    }

    private RawGlyph m_95081_(int charIn) {
        for (GlyphProvider glyphprovider : this.f_95055_) {
            RawGlyph rawglyph = glyphprovider.m_7823_(charIn);
            if (rawglyph == null) continue;
            return rawglyph;
        }
        return MissingGlyph.INSTANCE;
    }

    public BakedGlyph m_95078_(int character) {
        Object texturedGlyph = (BakedGlyph)this.f_95056_.get(character);
        if (texturedGlyph == null) {
            texturedGlyph = character == 32 || character == 8204 ? f_95048_ : this.m_95069_(this.m_95081_(character));
            this.f_95056_.put(character, texturedGlyph);
        }
        return texturedGlyph;
    }

    private BakedGlyph m_95069_(RawGlyph glyphInfoIn) {
        for (FontTexture fonttexture : this.f_95059_) {
            BakedGlyph bakedglyph = fonttexture.m_95102_(glyphInfoIn);
            if (bakedglyph == null) continue;
            return bakedglyph;
        }
        FontTexture fonttexture1 = new FontTexture(new ResourceLocation(this.f_95052_.m_135827_(), this.f_95052_.m_135815_() + "/" + this.f_95059_.size()), glyphInfoIn.m_5633_());
        this.f_95059_.add(fonttexture1);
        this.f_95051_.m_118495_(fonttexture1.m_95099_(), (AbstractTexture)fonttexture1);
        BakedGlyph bakedglyph1 = fonttexture1.m_95102_(glyphInfoIn);
        return bakedglyph1 == null ? this.f_95053_ : bakedglyph1;
    }

    public BakedGlyph m_95067_(GlyphInfo glyph) {
        IntList intlist = (IntList)this.f_95058_.get(Mth.m_14167_((float)glyph.m_83827_(false)));
        return intlist != null && !intlist.isEmpty() ? this.m_95078_(intlist.getInt(f_95050_.nextInt(intlist.size()))) : this.f_95053_;
    }

    public BakedGlyph m_95064_() {
        return this.f_95054_;
    }
}

