/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.PopupScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GpuWarnlistManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiAnimationSettingsOF;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiDetailSettingsOF;
import net.optifine.gui.GuiOtherSettingsOF;
import net.optifine.gui.GuiPerformanceSettingsOF;
import net.optifine.gui.GuiQualitySettingsOF;
import net.optifine.gui.GuiScreenButtonOF;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProvider;
import net.optifine.gui.TooltipProviderOptions;
import net.optifine.shaders.gui.GuiShaders;
import net.optifine.util.GuiUtils;
import org.lwjgl.glfw.GLFW;

/*
 * Exception performing whole class analysis ignored.
 */
public class VideoSettingsScreen
extends GuiScreenOF {
    private Screen parentGuiScreen;
    private Options guiGameSettings;
    private static Option[] videoOptions = new Option[]{Option.f_91682_, Option.f_91675_, Option.f_91679_, Option.f_193600_, Option.AO_LEVEL, Option.f_91670_, Option.f_91683_, Option.f_91639_, Option.f_91671_, Option.f_91680_, Option.DYNAMIC_LIGHTS, Option.DYNAMIC_FOV};
    private GpuWarnlistManager f_96802_;
    private static final Component f_96794_ = new TranslatableComponent("options.graphics.fabulous").m_130940_(ChatFormatting.ITALIC);
    private static final Component f_96795_ = new TranslatableComponent("options.graphics.warning.message", new Object[]{f_96794_, f_96794_});
    private static final Component f_96796_ = new TranslatableComponent("options.graphics.warning.title").m_130940_(ChatFormatting.RED);
    private static final Component f_96797_ = new TranslatableComponent("options.graphics.warning.accept");
    private static final Component f_96798_ = new TranslatableComponent("options.graphics.warning.cancel");
    private static final Component f_96799_ = new TextComponent("\n");
    private TooltipManager tooltipManager = new TooltipManager((Screen)this, (TooltipProvider)new TooltipProviderOptions());
    private List<AbstractWidget> buttonList = this.getButtonList();
    private AbstractWidget buttonGuiScale;

    public VideoSettingsScreen(Screen par1GuiScreen, Options par2GameSettings) {
        super((Component)new TranslatableComponent("options.videoTitle"));
        this.parentGuiScreen = par1GuiScreen;
        this.guiGameSettings = par2GameSettings;
        this.f_96802_ = this.parentGuiScreen.f_96541_.m_91105_();
        this.f_96802_.m_109252_();
        if (this.guiGameSettings.f_92115_ == GraphicsStatus.FABULOUS) {
            this.f_96802_.m_109248_();
        }
    }

    public void m_7856_() {
        this.buttonList.clear();
        for (int i2 = 0; i2 < videoOptions.length; ++i2) {
            Option opt = videoOptions[i2];
            if (opt == null) continue;
            int x = this.f_96543_ / 2 - 155 + i2 % 2 * 160;
            int y = this.f_96544_ / 6 + 21 * (i2 / 2) - 12;
            AbstractWidget guiElement = (AbstractWidget)this.m_142416_((GuiEventListener)opt.m_7496_(this.f_96541_.f_91066_, x, y, 150));
            if (opt != Option.f_91683_) continue;
            this.buttonGuiScale = guiElement;
        }
        int y = this.f_96544_ / 6 + 21 * (videoOptions.length / 2) - 12;
        int x = 0;
        x = this.f_96543_ / 2 - 155 + 0;
        this.m_142416_((GuiEventListener)new GuiScreenButtonOF(231, x, y, Lang.get((String)"of.options.shaders")));
        x = this.f_96543_ / 2 - 155 + 160;
        this.m_142416_((GuiEventListener)new GuiScreenButtonOF(202, x, y, Lang.get((String)"of.options.quality")));
        x = this.f_96543_ / 2 - 155 + 0;
        this.m_142416_((GuiEventListener)new GuiScreenButtonOF(201, x, y += 21, Lang.get((String)"of.options.details")));
        x = this.f_96543_ / 2 - 155 + 160;
        this.m_142416_((GuiEventListener)new GuiScreenButtonOF(212, x, y, Lang.get((String)"of.options.performance")));
        x = this.f_96543_ / 2 - 155 + 0;
        this.m_142416_((GuiEventListener)new GuiScreenButtonOF(211, x, y += 21, Lang.get((String)"of.options.animations")));
        x = this.f_96543_ / 2 - 155 + 160;
        this.m_142416_((GuiEventListener)new GuiScreenButtonOF(222, x, y, Lang.get((String)"of.options.other")));
        y += 21;
        this.m_142416_((GuiEventListener)new GuiButtonOF(200, this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 168 + 11, I18n.m_118938_((String)"gui.done", (Object[])new Object[0])));
        this.buttonList = this.getButtonList();
    }

    protected void actionPerformed(AbstractWidget button) {
        if (button == this.buttonGuiScale) {
            this.updateGuiScale();
        }
        this.checkFabulousWarning();
        if (!(button instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF gbo = (GuiButtonOF)button;
        this.actionPerformed(gbo, 1);
    }

    private void checkFabulousWarning() {
        if (this.f_96802_.m_109250_()) {
            String s2;
            String s1;
            ArrayList list = Lists.newArrayList((Object[])new Component[]{f_96795_, f_96799_});
            String s = this.f_96802_.m_109253_();
            if (s != null) {
                list.add(f_96799_);
                list.add(new TranslatableComponent("options.graphics.warning.renderer", new Object[]{s}).m_130940_(ChatFormatting.GRAY));
            }
            if ((s1 = this.f_96802_.m_109255_()) != null) {
                list.add(f_96799_);
                list.add(new TranslatableComponent("options.graphics.warning.vendor", new Object[]{s1}).m_130940_(ChatFormatting.GRAY));
            }
            if ((s2 = this.f_96802_.m_109254_()) != null) {
                list.add(f_96799_);
                list.add(new TranslatableComponent("options.graphics.warning.version", new Object[]{s2}).m_130940_(ChatFormatting.GRAY));
            }
            this.f_96541_.m_91152_((Screen)new PopupScreen(f_96796_, (List)list, ImmutableList.of((Object)new PopupScreen.ButtonOption(f_96797_, btn -> {
                this.guiGameSettings.f_92115_ = GraphicsStatus.FABULOUS;
                Minecraft.m_91087_().f_91060_.m_109818_();
                this.f_96802_.m_109248_();
                this.f_96541_.m_91152_((Screen)this);
            }), (Object)new PopupScreen.ButtonOption(f_96798_, btn -> {
                this.f_96802_.m_109249_();
                this.f_96541_.m_91152_((Screen)this);
            }))));
        }
    }

    protected void actionPerformedRightClick(AbstractWidget button) {
        if (button == this.buttonGuiScale) {
            int newScale = this.guiGameSettings.f_92072_ - 1;
            if (newScale < 0) {
                newScale = Minecraft.m_91087_().m_91268_().m_85385_(0, Minecraft.m_91087_().m_91390_());
            }
            Option.f_91683_.f_90678_.m_167795_(this.guiGameSettings, (Option)Option.f_91683_, (Object)newScale);
            this.updateGuiScale();
        }
    }

    private void updateGuiScale() {
        this.f_96541_.m_5741_();
        Window mw = this.f_96541_.m_91268_();
        int btnWidth = GuiUtils.getWidth((AbstractWidget)this.buttonGuiScale);
        int btnHeight = GuiUtils.getHeight((AbstractWidget)this.buttonGuiScale);
        int x = this.buttonGuiScale.f_93620_ + (btnWidth - btnHeight);
        int y = this.buttonGuiScale.f_93621_ + btnHeight / 2;
        GLFW.glfwSetCursorPos((long)mw.m_85439_(), (double)((double)x * mw.m_85449_()), (double)((double)y * mw.m_85449_()));
    }

    private void actionPerformed(GuiButtonOF button, int val) {
        GuiDetailSettingsOF scr;
        if (!button.f_93623_) {
            return;
        }
        if (button.id == 200) {
            this.f_96541_.f_91066_.m_92169_();
            this.f_96541_.m_91152_(this.parentGuiScreen);
        }
        if (button.id == 201) {
            this.f_96541_.f_91066_.m_92169_();
            scr = new GuiDetailSettingsOF((Screen)this, this.guiGameSettings);
            this.f_96541_.m_91152_((Screen)scr);
        }
        if (button.id == 202) {
            this.f_96541_.f_91066_.m_92169_();
            scr = new GuiQualitySettingsOF((Screen)this, this.guiGameSettings);
            this.f_96541_.m_91152_((Screen)scr);
        }
        if (button.id == 211) {
            this.f_96541_.f_91066_.m_92169_();
            scr = new GuiAnimationSettingsOF((Screen)this, this.guiGameSettings);
            this.f_96541_.m_91152_((Screen)scr);
        }
        if (button.id == 212) {
            this.f_96541_.f_91066_.m_92169_();
            scr = new GuiPerformanceSettingsOF((Screen)this, this.guiGameSettings);
            this.f_96541_.m_91152_((Screen)scr);
        }
        if (button.id == 222) {
            this.f_96541_.f_91066_.m_92169_();
            scr = new GuiOtherSettingsOF((Screen)this, this.guiGameSettings);
            this.f_96541_.m_91152_((Screen)scr);
        }
        if (button.id == 231) {
            if (Config.isAntialiasing() || Config.isAntialiasingConfigured()) {
                Config.showGuiMessage((String)Lang.get((String)"of.message.shaders.aa1"), (String)Lang.get((String)"of.message.shaders.aa2"));
                return;
            }
            if (Config.isGraphicsFabulous()) {
                Config.showGuiMessage((String)Lang.get((String)"of.message.shaders.gf1"), (String)Lang.get((String)"of.message.shaders.gf2"));
                return;
            }
            this.f_96541_.f_91066_.m_92169_();
            scr = new GuiShaders((Screen)this, this.guiGameSettings);
            this.f_96541_.m_91152_((Screen)scr);
        }
    }

    public void m_7861_() {
        this.f_96541_.f_91066_.m_92169_();
        super.m_7861_();
    }

    public void m_6305_(PoseStack matrixStackIn, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStackIn);
        VideoSettingsScreen.m_93215_((PoseStack)matrixStackIn, (Font)this.f_96541_.f_91062_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        String ver = Config.getVersion();
        String ed = "HD_U";
        if (ed.equals("HD")) {
            ver = "OptiFine HD H7";
        }
        if (ed.equals("HD_U")) {
            ver = "OptiFine HD H7 Ultra";
        }
        if (ed.equals("L")) {
            ver = "OptiFine H7 Light";
        }
        VideoSettingsScreen.m_93236_((PoseStack)matrixStackIn, (Font)this.f_96541_.f_91062_, (String)ver, (int)2, (int)(this.f_96544_ - 10), (int)0x808080);
        String verMc = "Minecraft 1.18.2";
        int lenMc = this.f_96541_.f_91062_.m_92895_(verMc);
        VideoSettingsScreen.m_93236_((PoseStack)matrixStackIn, (Font)this.f_96541_.f_91062_, (String)verMc, (int)(this.f_96543_ - lenMc - 2), (int)(this.f_96544_ - 10), (int)0x808080);
        super.m_6305_(matrixStackIn, mouseX, mouseY, partialTicks);
        this.tooltipManager.drawTooltips(matrixStackIn, mouseX, mouseY, this.buttonList);
    }

    public static String getGuiChatText(ChatScreen guiChat) {
        return guiChat.f_95573_.m_94155_();
    }
}

